/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

public final class Logger {
    private static IndeterminateSpinner spinner;

    public static Logger create() {
        return new Logger();
    }

    public void println(String text) {
        this.closeSpinner();
        System.out.println(text);
    }

    private void closeSpinner() {
        if (spinner != null) {
            spinner.end();
            spinner = null;
            System.out.println();
        }
    }

    public IndeterminateSpinner spinner(String message) {
        this.closeSpinner();
        System.out.print(message);
        spinner = new IndeterminateSpinner();
        return spinner;
    }

    public static class IndeterminateSpinner {
        String[] spinners = new String[]{"", ".", "..", "..."};
        String lastTextPrinted = "";
        int spinnerIndex = 0;

        public IndeterminateSpinner() {
            this.tick();
        }

        public void tick() {
            if (!this.lastTextPrinted.isEmpty()) {
                System.out.print("\b".repeat(this.lastTextPrinted.length()));
            }
            this.lastTextPrinted = this.spinners[++this.spinnerIndex % this.spinners.length];
            System.out.print(this.lastTextPrinted);
        }

        public void end() {
            if (spinner == this) {
                System.out.print("\b".repeat(this.lastTextPrinted.length()));
                this.lastTextPrinted = "";
                spinner = null;
            }
        }
    }
}

