/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;

public interface ProcessingEnvironment {
    public ArtifactManager getArtifactManager();

    public Path getWorkspace();

    public String interpolateString(String var1) throws IOException;

    public Path extractData(String var1) throws IOException;

    default public Path getRequiredInputPath(String id) {
        try {
            return this.getRequiredInput(id, ResultRepresentation.PATH);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T getRequiredInput(String var1, ResultRepresentation<T> var2) throws IOException;

    public Path getOutputPath(String var1);

    public void setOutput(String var1, Path var2);

    public boolean isVerbose();

    default public String getPathArgument(Path path) {
        if (path.startsWith(this.getWorkspace())) {
            return path.relativize(path).toString();
        }
        return path.toString();
    }
}

