/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.actions.ApplySourceAccessTransformersAction;
import net.neoforged.neoform.runtime.actions.InjectFromZipFileSource;
import net.neoforged.neoform.runtime.actions.InjectZipContentAction;
import net.neoforged.neoform.runtime.actions.PatchActionFactory;
import net.neoforged.neoform.runtime.actions.RecompileSourcesAction;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cli.Main;
import net.neoforged.neoform.runtime.cli.NeoFormEngineCommand;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.graph.NodeOutputType;
import net.neoforged.neoform.runtime.graph.transforms.GraphTransform;
import net.neoforged.neoform.runtime.graph.transforms.ModifyAction;
import net.neoforged.neoform.runtime.graph.transforms.ReplaceNodeOutput;
import net.neoforged.neoform.runtime.utils.FileUtil;
import net.neoforged.neoform.runtime.utils.HashingUtil;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run the NeoForm engine and produce Minecraft artifacts"})
public class RunNeoFormCommand
extends NeoFormEngineCommand {
    private static final Logger LOG = Logger.create();
    @CommandLine.ParentCommand
    Main commonOptions;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="1")
    SourceArtifacts sourceArtifacts;
    @CommandLine.Option(names={"--dist"}, required=true)
    String dist;
    @CommandLine.Option(names={"--write-result"}, arity="*")
    List<String> writeResults = new ArrayList<String>();
    @CommandLine.Option(names={"--access-transformer"}, arity="*")
    List<String> additionalAccessTransformers = new ArrayList<String>();
    @CommandLine.Option(names={"--parchment-data"}, description={"Path or Maven coordinates of parchment data to use"})
    String parchmentData;

    @Override
    protected void runWithNeoFormEngine(NeoFormEngine engine, List<AutoCloseable> closables) throws IOException, InterruptedException {
        ArtifactManager artifactManager = engine.getArtifactManager();
        if (this.sourceArtifacts.neoforge != null) {
            Artifact neoforgeArtifact = artifactManager.get(this.sourceArtifacts.neoforge);
            JarFile neoforgeZipFile = engine.addManagedResource(new JarFile(neoforgeArtifact.path().toFile()));
            NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
            MavenCoordinate neoformArtifact = MavenCoordinate.parse(neoforgeConfig.neoformArtifact());
            if (this.sourceArtifacts.neoform != null) {
                LOG.println("Overriding NeoForm version " + String.valueOf(neoformArtifact) + " with CLI argument " + this.sourceArtifacts.neoform);
                neoformArtifact = MavenCoordinate.parse(this.sourceArtifacts.neoform);
            }
            engine.loadNeoFormData(neoformArtifact, this.dist);
            engine.addDataSource("neoForgeAccessTransformers", neoforgeZipFile, neoforgeConfig.accessTransformersFolder());
            ArrayList<GraphTransform> transforms = new ArrayList<GraphTransform>();
            transforms.add(new ModifyAction<RecompileSourcesAction>("recompile", RecompileSourcesAction.class, action -> action.getClasspath().addMavenLibraries(neoforgeConfig.libraries())));
            Path neoforgeSources = artifactManager.get(neoforgeConfig.sourcesArtifact()).path();
            ZipFile neoforgeSourcesZip = new ZipFile(neoforgeSources.toFile());
            closables.add(neoforgeSourcesZip);
            ApplySourceAccessTransformersAction transformSources = RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
            transformSources.setAccessTransformersData(List.of("neoForgeAccessTransformers"));
            transformSources.setAdditionalAccessTransformers(this.additionalAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            transforms.add(new ModifyAction<InjectZipContentAction>("inject", InjectZipContentAction.class, action -> action.getInjectedSources().add(new InjectFromZipFileSource(neoforgeSourcesZip, "/"))));
            transforms.add(new ReplaceNodeOutput("patch", "output", "applyNeoforgePatches", (builder, previousOutput) -> PatchActionFactory.makeAction(builder, neoforgeArtifact.path(), neoforgeConfig.patchesFolder(), previousOutput)));
            engine.applyTransforms(transforms);
        } else {
            engine.loadNeoFormData(MavenCoordinate.parse(this.sourceArtifacts.neoform), this.dist);
        }
        if (this.parchmentData != null) {
            ApplySourceAccessTransformersAction transformSources = RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
            Artifact parchmentDataFile = artifactManager.get(this.parchmentData);
            transformSources.setParchmentData(parchmentDataFile.path());
        }
        this.execute(engine);
    }

    private void execute(NeoFormEngine engine) throws InterruptedException, IOException {
        Map<String, Path> neededResults;
        if (this.printGraph) {
            StringWriter stringWriter = new StringWriter();
            engine.dumpGraph(new PrintWriter(stringWriter));
            LOG.println(stringWriter.toString());
        }
        if ((neededResults = this.writeResults.stream().map(encodedResult -> {
            String[] parts = encodedResult.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Specify a result destination in the form: <resultid>:<destination>");
            }
            return parts;
        }).collect(Collectors.toMap(parts -> parts[0], parts -> Paths.get(parts[1], new String[0])))).isEmpty()) {
            System.err.println("No results requested. Available results: " + String.valueOf(engine.getAvailableResults()));
            System.exit(1);
        }
        Map<String, Path> results = engine.createResults(neededResults.keySet().toArray(new String[0]));
        for (Map.Entry<String, Path> entry : neededResults.entrySet()) {
            Path result = results.get(entry.getKey());
            if (result == null) {
                throw new IllegalStateException("Result " + entry.getKey() + " was requested but not produced");
            }
            String resultFileHash = HashingUtil.hashFile(result, "SHA-1");
            try {
                if (HashingUtil.hashFile(entry.getValue(), "SHA-1").equals(resultFileHash)) {
                    continue;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            Path tmpFile = Paths.get(String.valueOf(entry.getValue()) + ".tmp", new String[0]);
            Files.copy(result, tmpFile, StandardCopyOption.REPLACE_EXISTING);
            FileUtil.atomicMove(tmpFile, entry.getValue());
        }
    }

    private static ApplySourceAccessTransformersAction getOrAddTransformSourcesNode(NeoFormEngine engine) {
        ExecutionGraph graph = engine.getGraph();
        ExecutionNode transformNode = graph.getNode("transformSources");
        if (transformNode != null) {
            ExecutionNodeAction executionNodeAction = transformNode.action();
            if (executionNodeAction instanceof ApplySourceAccessTransformersAction) {
                ApplySourceAccessTransformersAction action = (ApplySourceAccessTransformersAction)executionNodeAction;
                return action;
            }
            throw new IllegalStateException("Node transformSources has a different action type than expected. Expected: " + String.valueOf(ApplySourceAccessTransformersAction.class) + " but got " + String.valueOf(transformNode.action().getClass()));
        }
        new ReplaceNodeOutput("patch", "output", "transformSources", (builder, previousNodeOutput) -> {
            builder.input("input", previousNodeOutput.asInput());
            builder.inputFromNodeOutput("libraries", "listLibraries", "output");
            ApplySourceAccessTransformersAction action = new ApplySourceAccessTransformersAction();
            builder.action(action);
            return builder.output("output", NodeOutputType.ZIP, "Sources with additional transforms (ATs, Parchment) applied");
        }).apply(engine, graph);
        return RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
    }

    static class SourceArtifacts {
        @CommandLine.Option(names={"--neoform"})
        String neoform;
        @CommandLine.Option(names={"--neoforge"})
        String neoforge;

        SourceArtifacts() {
        }
    }
}

