/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.InjectSource;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cli.FileHashService;
import org.jetbrains.annotations.Nullable;

public record InjectFromDirectorySource(Path folder) implements InjectSource
{
    @Override
    public CacheKey.AnnotatedValue getCacheKey(FileHashService fileHashService) throws IOException {
        return new CacheKey.AnnotatedValue(fileHashService.getHashValue(this.folder), this.folder.toString());
    }

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        Path file = this.folder.resolve(path);
        try {
            return Files.readAllBytes(file);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        try (Stream<Path> stream = Files.walk(this.folder, new FileVisitOption[0]).sorted();){
            stream.forEach(path -> {
                String outputPath = this.folder.relativize((Path)path).toString().replace('\\', '/');
                try {
                    out.putNextEntry(new ZipEntry(outputPath));
                    Files.copy(path, out);
                    out.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }
}

