/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.engine;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.config.neoform.NeoFormDistConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormStep;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;

public final class NeoFormInterpolator {
    public static final Pattern TOKEN_PATTERN = Pattern.compile("\\{([^}]+)}");
    private final ProcessingEnvironment environment;
    private final NeoFormStep step;
    private final NeoFormDistConfig neoFormConfig;
    private final ZipFile neoFormArchive;

    public NeoFormInterpolator(ProcessingEnvironment environment, NeoFormStep step, NeoFormDistConfig neoFormConfig, ZipFile neoFormArchive) {
        this.environment = environment;
        this.step = step;
        this.neoFormConfig = neoFormConfig;
        this.neoFormArchive = neoFormArchive;
    }

    public static void collectReferencedVariables(String text, Set<String> variables) {
        Matcher matcher = TOKEN_PATTERN.matcher(text);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
    }

    public String interpolate(String text) {
        Matcher matcher = TOKEN_PATTERN.matcher(text);
        return matcher.replaceAll(matchResult -> Matcher.quoteReplacement(this.resolveRequiredInput(matchResult.group(1))));
    }

    public String resolveRequiredInput(String inputId) {
        String stepValue = this.step.values().get(inputId);
        if (stepValue != null) {
            if (!stepValue.contains("{")) {
                return stepValue;
            }
            return this.representPath(this.environment.getRequiredInputPath(inputId));
        }
        String dataPath = this.neoFormConfig.getDataPathInZip(inputId);
        if (dataPath != null) {
            return this.representPath(this.extractData(dataPath));
        }
        return this.representPath(this.environment.getOutputPath(inputId));
    }

    private Path extractData(String dataPath) {
        ZipEntry entry = this.neoFormArchive.getEntry(dataPath);
        if (entry == null) {
            throw new IllegalArgumentException("NeoForm archive entry " + dataPath + " does not exist.");
        }
        if (entry.getName().startsWith("/") || entry.getName().contains("..")) {
            throw new IllegalArgumentException("Unsafe ZIP path: " + entry.getName());
        }
        if (entry.isDirectory()) {
            throw new UnsupportedOperationException();
        }
        Path path = this.environment.getWorkspace().resolve(entry.getName());
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (InputStream in = this.neoFormArchive.getInputStream(entry);){
                    Files.copy(in, path, new CopyOption[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to extract referenced NeoForm data " + dataPath + " to " + String.valueOf(path), e);
            }
        }
        return path;
    }

    private String representPath(Path path) {
        Path result = this.environment.getWorkspace().relativize(path);
        if (result.getParent() == null) {
            return "./" + String.valueOf(result);
        }
        return result.toString();
    }
}

