/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.neoforged.neoform.runtime.cli.CacheMaintenance;
import net.neoforged.neoform.runtime.cli.CleanCacheCommand;
import net.neoforged.neoform.runtime.cli.DownloadAssetsCommand;
import net.neoforged.neoform.runtime.cli.RunNeoFormCommand;
import net.neoforged.neoform.runtime.utils.OsUtil;
import picocli.CommandLine;

@CommandLine.Command(name="neoform-runtime", subcommands={RunNeoFormCommand.class, DownloadAssetsCommand.class, CleanCacheCommand.class, CacheMaintenance.class}, mixinStandardHelpOptions=true)
public class Main {
    @CommandLine.Option(names={"--home-dir"}, scope=CommandLine.ScopeType.INHERIT, description={"Where NFRT should store caches."})
    Path homeDir = Main.getDefaultHomeDir();
    @CommandLine.Option(names={"--work-dir"}, scope=CommandLine.ScopeType.INHERIT, description={"Where temporary working directories are stored. Defaults to the subfolder 'work' in the NFRT home dir."})
    Path workDir;
    @CommandLine.Option(names={"--repository"}, arity="*", scope=CommandLine.ScopeType.INHERIT, description={"Overriddes Maven repositories used for downloading artifacts."})
    List<URI> repositories = List.of(URI.create("https://maven.neoforged.net/releases/"), Path.of(System.getProperty("user.home"), ".m2", "repository").toUri());
    @CommandLine.Option(names={"--add-repository"}, arity="*", scope=CommandLine.ScopeType.INHERIT, description={"Add Maven repositories for downloading artifacts."})
    List<URI> additionalRepositories = new ArrayList<URI>();
    @CommandLine.Option(names={"--artifact-manifest"}, scope=CommandLine.ScopeType.INHERIT)
    Path artifactManifest;
    @CommandLine.Option(names={"--launcher-meta-uri"}, scope=CommandLine.ScopeType.INHERIT)
    URI launcherManifestUrl = URI.create("https://launchermeta.mojang.com/mc/game/version_manifest_v2.json");
    @CommandLine.Option(names={"--verbose"}, description={"Enable verbose output"}, scope=CommandLine.ScopeType.INHERIT)
    boolean verbose;

    public Path getWorkDir() {
        return Objects.requireNonNullElseGet(this.workDir, () -> this.homeDir.resolve("work"));
    }

    private static Path getDefaultHomeDir() {
        Path userHomeDir = Paths.get(System.getProperty("user.home"), new String[0]);
        if (OsUtil.isLinux()) {
            String xdgCacheHome = System.getenv("XDG_CACHE_DIR");
            if (xdgCacheHome != null && xdgCacheHome.startsWith("/")) {
                return Paths.get(xdgCacheHome, new String[0]).resolve("neoformruntime");
            }
            return userHomeDir.resolve(".cache/neoformruntime");
        }
        return userHomeDir.resolve(".neoformruntime");
    }

    public static void main(String ... args) {
        CommandLine commandLine = new CommandLine(new Main());
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    public List<URI> getEffectiveRepositories() {
        ArrayList<URI> result = new ArrayList<URI>(this.repositories);
        result.addAll(this.additionalRepositories);
        return result;
    }
}

