/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.artifacts;

import java.net.URI;
import java.nio.file.Path;
import net.neoforged.neoform.runtime.manifests.MinecraftLibrary;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public sealed interface ClasspathItem {
    public static ClasspathItem of(Path path) {
        return new PathItem(path);
    }

    public static ClasspathItem of(MinecraftLibrary library) {
        return new MinecraftLibraryItem(library);
    }

    public static ClasspathItem of(MavenCoordinate mavenLibrary) {
        return new MavenCoordinateItem(mavenLibrary, null);
    }

    public static ClasspathItem of(MavenCoordinate mavenLibrary, @Nullable URI repositoryBaseUrl) {
        return new MavenCoordinateItem(mavenLibrary, repositoryBaseUrl);
    }

    public record PathItem(Path path) implements ClasspathItem
    {
        @Override
        public String toString() {
            return this.path.toString();
        }
    }

    public record MinecraftLibraryItem(MinecraftLibrary library) implements ClasspathItem
    {
        @Override
        public String toString() {
            return this.library.toString();
        }
    }

    public record MavenCoordinateItem(MavenCoordinate coordinate, @Nullable URI repositoryBaseUrl) implements ClasspathItem
    {
        @Override
        public String toString() {
            if (this.repositoryBaseUrl == null) {
                return this.coordinate.toString();
            }
            return String.valueOf(this.coordinate) + " from " + String.valueOf(this.repositoryBaseUrl);
        }
    }
}

