/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.artifacts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.downloads.DownloadSpec;
import net.neoforged.neoform.runtime.manifests.LauncherManifest;
import net.neoforged.neoform.runtime.manifests.MinecraftDownload;
import net.neoforged.neoform.runtime.manifests.MinecraftLibrary;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;
import net.neoforged.neoform.runtime.utils.FilenameUtil;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;

public class ArtifactManager {
    private static final Logger LOG = Logger.create();
    private static final URI MINECRAFT_LIBRARIES_URI = URI.create("https://libraries.minecraft.net");
    private final List<URI> repositoryBaseUrls;
    private final DownloadManager downloadManager;
    private final LockManager lockManager;
    private final URI launcherManifestUrl;
    private final Path artifactsCache;
    private final Map<MavenCoordinate, Artifact> externallyProvided = new HashMap<MavenCoordinate, Artifact>();

    public ArtifactManager(List<URI> repositoryBaseUrls, CacheManager cacheManager, DownloadManager downloadManager, LockManager lockManager, URI launcherManifestUrl) {
        this.repositoryBaseUrls = repositoryBaseUrls;
        this.downloadManager = downloadManager;
        this.lockManager = lockManager;
        this.launcherManifestUrl = launcherManifestUrl;
        this.artifactsCache = cacheManager.getArtifactCacheDir();
    }

    public Artifact get(MinecraftLibrary library) throws IOException {
        MinecraftDownload artifact = library.getArtifactDownload();
        if (artifact == null) {
            throw new IllegalArgumentException("Cannot download a library that has no artifact defined: " + String.valueOf(library));
        }
        MavenCoordinate artifactCoordinate = MavenCoordinate.parse(library.artifactId());
        if (this.externallyProvided.containsKey(artifactCoordinate)) {
            return this.externallyProvided.get(artifactCoordinate);
        }
        Path finalLocation = this.artifactsCache.resolve(artifactCoordinate.toRelativeRepositoryPath());
        return this.download(finalLocation, artifact);
    }

    public Artifact get(String location, URI repositoryBaseUrl) throws IOException {
        return this.get(MavenCoordinate.parse(location), repositoryBaseUrl);
    }

    public Artifact get(MavenCoordinate artifactCoordinate, URI repositoryBaseUrl) throws IOException {
        if (this.externallyProvided.containsKey(artifactCoordinate)) {
            return this.externallyProvided.get(artifactCoordinate);
        }
        Path finalLocation = this.artifactsCache.resolve(artifactCoordinate.toRelativeRepositoryPath());
        URI url = artifactCoordinate.toRepositoryUri(repositoryBaseUrl);
        return this.download(finalLocation, url);
    }

    public Artifact get(String location) throws IOException {
        MavenCoordinate coordinate;
        try {
            coordinate = MavenCoordinate.parse(location);
        }
        catch (IllegalArgumentException ignored) {
            return this.getArtifactFromPath(location);
        }
        return this.get(coordinate);
    }

    public Artifact get(MavenCoordinate mavenCoordinate) throws IOException {
        if (this.externallyProvided.containsKey(mavenCoordinate)) {
            return this.externallyProvided.get(mavenCoordinate);
        }
        Path finalLocation = this.artifactsCache.resolve(mavenCoordinate.toRelativeRepositoryPath());
        if (mavenCoordinate.groupId().equals("com.mojang") && mavenCoordinate.artifactId().equals("logging")) {
            return this.get(mavenCoordinate, MINECRAFT_LIBRARIES_URI);
        }
        return this.download(finalLocation, () -> {
            for (URI repositoryBaseUrl : this.repositoryBaseUrls) {
                URI url = mavenCoordinate.toRepositoryUri(repositoryBaseUrl);
                try {
                    this.downloadManager.download(url, finalLocation);
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            throw new FileNotFoundException("Could not find " + String.valueOf(mavenCoordinate) + " in any repository.");
        });
    }

    /*
     * Loose catch block
     */
    public List<Path> resolveClasspath(Collection<ClasspathItem> classpathItems) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>(classpathItems.size());
        for (ClasspathItem item : classpathItems) {
            ClasspathItem classpathItem;
            Objects.requireNonNull(item);
            int n = 0;
            Path pathToAdd = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClasspathItem.MavenCoordinateItem.class, ClasspathItem.MinecraftLibraryItem.class, ClasspathItem.PathItem.class}, (Object)classpathItem, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ClasspathItem.MavenCoordinateItem var8_9 = (ClasspathItem.MavenCoordinateItem)classpathItem;
                    Object var11_12 = var8_9.coordinate();
                    Record mavenCoordinate = var11_12;
                    Object repositoryUri = var11_12 = var8_9.repositoryBaseUrl();
                    if (repositoryUri == null) {
                        yield this.get((MavenCoordinate)mavenCoordinate).path();
                    }
                    yield this.get((MavenCoordinate)mavenCoordinate, (URI)repositoryUri).path();
                }
                case 1 -> {
                    Record var13_14;
                    Object var11_12 = (ClasspathItem.MinecraftLibraryItem)classpathItem;
                    Record library = var13_14 = ((ClasspathItem.MinecraftLibraryItem)var11_12).library();
                    yield this.get((MinecraftLibrary)library).path();
                }
                case 2 -> {
                    Path var15_16;
                    Path path;
                    Record var13_14 = (ClasspathItem.PathItem)classpathItem;
                    yield path = (var15_16 = var13_14.path());
                }
            };
            result.add(pathToAdd);
        }
        return result;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Artifact getVersionManifest(String minecraftVersion) throws IOException {
        Path finalLocation = this.artifactsCache.resolve("minecraft_" + minecraftVersion + "_version_manifest.json");
        return this.download(finalLocation, () -> {
            Artifact launcherManifestArtifact = this.getLauncherManifest();
            LauncherManifest launcherManifest = LauncherManifest.from(launcherManifestArtifact.path());
            LauncherManifest.Version versionEntry = launcherManifest.versions().stream().filter(v -> minecraftVersion.equals(v.id())).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find Minecraft version: " + minecraftVersion));
            this.downloadManager.download(versionEntry.url(), finalLocation);
        });
    }

    public Artifact getLauncherManifest() throws IOException {
        Path finalLocation = this.artifactsCache.resolve("minecraft_launcher_manifest.json");
        return this.download(finalLocation, this.launcherManifestUrl);
    }

    public Artifact downloadFromManifest(MinecraftVersionManifest versionManifest, String type) throws IOException {
        MinecraftDownload downloadSpec = versionManifest.downloads().get(type);
        if (downloadSpec == null) {
            throw new IllegalArgumentException("Minecraft version manifest " + versionManifest.id() + " does not declare a download for " + type + ". Available: " + String.valueOf(versionManifest.downloads().keySet()));
        }
        String extension = FilenameUtil.getExtension(downloadSpec.uri().getPath());
        Path finalPath = this.artifactsCache.resolve("minecraft_" + versionManifest.id() + "_" + type + extension);
        return this.download(finalPath, downloadSpec);
    }

    public void loadArtifactManifest(Path artifactManifestPath) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(artifactManifestPath, new OpenOption[0]);){
            properties.load(in);
        }
        for (String artifactId : properties.stringPropertyNames()) {
            String value = properties.getProperty(artifactId);
            try {
                this.externallyProvided.put(MavenCoordinate.parse(artifactId), this.getArtifactFromPath(value));
            }
            catch (Exception e) {
                System.err.println("Failed to pre-load artifact '" + artifactId + "' from path '" + value + "': " + String.valueOf(e));
                System.exit(1);
            }
        }
        LOG.println("Loaded " + properties.size() + " artifacts from " + String.valueOf(artifactManifestPath));
    }

    private Artifact getArtifactFromPath(String path) throws IOException {
        return this.getArtifactFromPath(Paths.get(path, new String[0]));
    }

    private Artifact getArtifactFromPath(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        BasicFileAttributes attrView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return new Artifact(path, attrView.lastModifiedTime().toMillis(), attrView.size());
    }

    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    private Artifact download(Path finalLocation, DownloadAction downloadAction) throws IOException {
        BasicFileAttributeView attributeView = Files.getFileAttributeView(finalLocation, BasicFileAttributeView.class, new LinkOption[0]);
        try {
            attributeView.setTimes(null, FileTime.from(Instant.now()), null);
        }
        catch (NoSuchFileException e) {
            String lockKey = finalLocation.toAbsolutePath().normalize().toString();
            try (LockManager.Lock ignored = this.lockManager.lock(lockKey);){
                if (!Files.exists(finalLocation, new LinkOption[0])) {
                    downloadAction.run();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BasicFileAttributes attributes = attributeView.readAttributes();
        if (!attributes.isRegularFile()) {
            throw new IOException("Corrupted artifact: " + String.valueOf(finalLocation) + ". Expected a file.");
        }
        return new Artifact(finalLocation, attributes.lastModifiedTime().toMillis(), attributes.size());
    }

    private Artifact download(Path finalLocation, URI uri) throws IOException {
        return this.download(finalLocation, DownloadSpec.of(uri));
    }

    private Artifact download(Path finalLocation, DownloadSpec spec) throws IOException {
        return this.download(finalLocation, () -> this.downloadManager.download(spec, finalLocation));
    }

    @FunctionalInterface
    public static interface DownloadAction {
        public void run() throws IOException;
    }
}

