/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.RangedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class PlayerInventoryWrapper
extends VanillaContainerWrapper {
    private final DroppedItems droppedItems = new DroppedItems(this);
    private final Inventory inventory;

    public static PlayerInventoryWrapper of(Player player) {
        return PlayerInventoryWrapper.of(player.getInventory());
    }

    public static PlayerInventoryWrapper of(Inventory inventory) {
        return (PlayerInventoryWrapper)VanillaContainerWrapper.of((Container)inventory);
    }

    PlayerInventoryWrapper(Inventory inventory) {
        super((Container)inventory);
        this.inventory = inventory;
    }

    @Override
    void resize() {
        this.size = 41;
        while (this.slotWrappers.size() < this.size) {
            int index = this.slotWrappers.size();
            if (36 <= index && index < 40) {
                EquipmentSlot equipmentSlot = (EquipmentSlot)Inventory.EQUIPMENT_SLOT_MAPPING.get(index);
                this.slotWrappers.add(new ArmorSlotWrapper(this, index, equipmentSlot));
                continue;
            }
            this.slotWrappers.add(new VanillaContainerWrapper.SlotWrapper(this, index));
        }
    }

    @Override
    void onRootCommit() {
        super.onRootCommit();
        if (!this.inventory.player.level().isClientSide()) {
            this.inventory.player.containerMenu.broadcastChanges();
        }
    }

    public ResourceHandler<ItemResource> getSlot(int slot) {
        return this.getSlotWrapper(slot);
    }

    public ResourceHandler<ItemResource> getMainHandSlot() {
        if (Inventory.isHotbarSlot((int)this.inventory.getSelectedSlot())) {
            return this.getSlot(this.inventory.getSelectedSlot());
        }
        throw new RuntimeException("Unexpected player selected slot: " + this.inventory.getSelectedSlot());
    }

    public ResourceHandler<ItemResource> getHandSlot(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> this.getMainHandSlot();
            case InteractionHand.OFF_HAND -> this.getSlot(40);
        };
    }

    public ResourceHandler<ItemResource> getHandSlots() {
        return new CombinedResourceHandler<ItemResource>(this.getMainHandSlot(), this.getHandSlot(InteractionHand.OFF_HAND));
    }

    public ResourceHandler<ItemResource> getMainSlots() {
        return RangedResourceHandler.of(this, 0, 36);
    }

    public ResourceHandler<ItemResource> getArmorSlot(EquipmentSlot slot) {
        if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) {
            throw new IllegalArgumentException("EquipmentSlot is not an armor slot: " + String.valueOf(slot));
        }
        return this.getSlot(slot.getIndex(36));
    }

    public ResourceHandler<ItemResource> getArmorSlots() {
        return RangedResourceHandler.of(this, 36, 40);
    }

    @Override
    public int insert(ItemResource resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        int inserted = 0;
        for (InteractionHand hand : InteractionHand.values()) {
            ResourceHandler<ItemResource> handSlot = this.getHandSlot(hand);
            if (!handSlot.getResource(0).equals(resource) || (inserted += handSlot.insert(resource, amount - inserted, transaction)) != amount) continue;
            return inserted;
        }
        inserted += ResourceHandlerUtil.insertStacking(this.getMainSlots(), resource, amount - inserted, transaction);
        return inserted;
    }

    public void placeItemBackInInventory(ItemResource resource, int amount, TransactionContext transactionContext) {
        int inserted = this.insert(resource, amount, transactionContext);
        if (inserted < amount) {
            this.drop(resource, amount - inserted, false, false, transactionContext);
        }
    }

    public void drop(ItemResource resource, int amount, boolean dropAround, boolean includeThrowerName, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        if (amount == 0) {
            return;
        }
        if (!this.inventory.player.level().isClientSide()) {
            this.droppedItems.addDrop(resource, amount, dropAround, includeThrowerName, transaction);
        }
    }

    @Override
    public String toString() {
        return "PlayerInventoryWrapper{player=%s}".formatted(this.inventory.player);
    }

    private class DroppedItems
    extends SnapshotJournal<Integer> {
        final Deque<DropInfo> entries;
        final /* synthetic */ PlayerInventoryWrapper this$0;

        private DroppedItems(PlayerInventoryWrapper playerInventoryWrapper) {
            PlayerInventoryWrapper playerInventoryWrapper2 = playerInventoryWrapper;
            Objects.requireNonNull(playerInventoryWrapper2);
            this.this$0 = playerInventoryWrapper2;
            this.entries = new ArrayDeque<DropInfo>();
        }

        void addDrop(ItemResource resource, int amount, boolean dropAround, boolean includeThrowerName, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            this.entries.add(new DropInfo(resource, amount, dropAround, includeThrowerName));
        }

        @Override
        protected Integer createSnapshot() {
            return this.entries.size();
        }

        @Override
        protected void revertToSnapshot(Integer snapshot) {
            int previousSize = snapshot;
            while (this.entries.size() > previousSize) {
                this.entries.removeLast();
            }
        }

        @Override
        protected void onRootCommit(Integer originalState) {
            while (!this.entries.isEmpty()) {
                int dropped;
                DropInfo dropInfo = this.entries.removeFirst();
                int maxStackSize = dropInfo.resource.getMaxStackSize();
                for (int remainder = dropInfo.amount; remainder > 0; remainder -= dropped) {
                    dropped = Math.min(maxStackSize, remainder);
                    CommonHooks.onPlayerTossEvent(this.this$0.inventory.player, dropInfo.resource.toStack(dropped), dropInfo.dropAround, dropInfo.includeThrowerName);
                }
            }
        }

        private record DropInfo(ItemResource resource, int amount, boolean dropAround, boolean includeThrowerName) {
        }
    }

    private class ArmorSlotWrapper
    extends VanillaContainerWrapper.SlotWrapper {
        private final EquipmentSlot slot;
        final /* synthetic */ PlayerInventoryWrapper this$0;

        ArmorSlotWrapper(PlayerInventoryWrapper playerInventoryWrapper, int index, EquipmentSlot slot) {
            PlayerInventoryWrapper playerInventoryWrapper2 = playerInventoryWrapper;
            Objects.requireNonNull(playerInventoryWrapper2);
            this.this$0 = playerInventoryWrapper2;
            super(playerInventoryWrapper, index);
            this.slot = slot;
        }

        @Override
        protected boolean isValid(ItemResource resource) {
            return resource.toStack().canEquip(this.slot, (LivingEntity)this.this$0.inventory.player) && super.isValid(resource);
        }

        @Override
        protected int getCapacity(ItemResource resource) {
            return this.slot.countLimit;
        }

        @Override
        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (!this.this$0.inventory.player.isCreative() && EnchantmentHelper.has((ItemStack)resource.toStack(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return 0;
            }
            return super.extract(index, resource, amount, transaction);
        }
    }
}

