/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStackResourceHandler;
import net.neoforged.neoforge.transfer.item.PlayerInventoryWrapper;

public class LivingEntityEquipmentWrapper {
    private static final Map<LivingEntity, LivingEntityEquipmentWrapper> wrappers = new MapMaker().weakKeys().weakValues().makeMap();
    private final LivingEntity entity;
    private final Map<EquipmentSlot.Type, EquipmentTypeWrapper> byType;

    public static ResourceHandler<ItemResource> of(LivingEntity entity, EquipmentSlot.Type equipmentType) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return switch (equipmentType) {
                case EquipmentSlot.Type.HAND -> PlayerInventoryWrapper.of(player).getHandSlots();
                case EquipmentSlot.Type.HUMANOID_ARMOR -> PlayerInventoryWrapper.of(player).getArmorSlots();
                default -> throw new IllegalArgumentException("Wrapping the equipment type " + String.valueOf(equipmentType) + " of a player is not supported.");
            };
        }
        return LivingEntityEquipmentWrapper.internalOf(entity, equipmentType);
    }

    public static ResourceHandler<ItemResource> of(LivingEntity entity, EquipmentSlot equipmentSlot) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (equipmentSlot == EquipmentSlot.MAINHAND) {
                return PlayerInventoryWrapper.of(player).getMainHandSlot();
            }
            if (equipmentSlot == EquipmentSlot.OFFHAND) {
                return PlayerInventoryWrapper.of(player).getHandSlot(InteractionHand.OFF_HAND);
            }
            if (equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                return PlayerInventoryWrapper.of(player).getArmorSlot(equipmentSlot);
            }
            throw new IllegalArgumentException("Wrapping the equipment slot " + String.valueOf(equipmentSlot) + " of a player is not supported.");
        }
        return LivingEntityEquipmentWrapper.internalOf(entity, equipmentSlot.getType()).getSlotWrapper(equipmentSlot.getIndex());
    }

    private static EquipmentTypeWrapper internalOf(LivingEntity entity, EquipmentSlot.Type equipmentType) {
        LivingEntityEquipmentWrapper wrapper = wrappers.computeIfAbsent(entity, LivingEntityEquipmentWrapper::new);
        return wrapper.byType.get(equipmentType);
    }

    private LivingEntityEquipmentWrapper(LivingEntity entity) {
        this.entity = entity;
        this.byType = new EnumMap<EquipmentSlot.Type, EquipmentTypeWrapper>(EquipmentSlot.Type.class);
        for (EquipmentSlot.Type equipmentType : EquipmentSlot.Type.values()) {
            ArrayList<SlotWrapper> slotWrappers = new ArrayList<SlotWrapper>();
            for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
                if (equipmentSlot.getType() != equipmentType) continue;
                slotWrappers.add(new SlotWrapper(this, equipmentSlot));
            }
            this.byType.put(equipmentType, new EquipmentTypeWrapper(this, (SlotWrapper[])slotWrappers.toArray(SlotWrapper[]::new)));
        }
    }

    private class EquipmentTypeWrapper
    extends CombinedResourceHandler<ItemResource> {
        EquipmentTypeWrapper(LivingEntityEquipmentWrapper livingEntityEquipmentWrapper, SlotWrapper ... handlers) {
            Objects.requireNonNull(livingEntityEquipmentWrapper);
            super(handlers);
        }

        SlotWrapper getSlotWrapper(int index) {
            return (SlotWrapper)this.getHandlerFromIndex(index);
        }
    }

    private class SlotWrapper
    extends ItemStackResourceHandler {
        private final EquipmentSlot slot;
        final /* synthetic */ LivingEntityEquipmentWrapper this$0;

        private SlotWrapper(LivingEntityEquipmentWrapper livingEntityEquipmentWrapper, EquipmentSlot slot) {
            LivingEntityEquipmentWrapper livingEntityEquipmentWrapper2 = livingEntityEquipmentWrapper;
            Objects.requireNonNull(livingEntityEquipmentWrapper2);
            this.this$0 = livingEntityEquipmentWrapper2;
            this.slot = slot;
        }

        @Override
        protected ItemStack getStack() {
            return this.this$0.entity.getItemBySlot(this.slot);
        }

        @Override
        protected void setStack(ItemStack stack) {
            this.this$0.entity.setItemSlot(this.slot, stack, true);
        }

        @Override
        protected boolean isValid(ItemResource resource) {
            return resource.toStack().canEquip(this.slot, this.this$0.entity);
        }

        @Override
        protected int getCapacity(ItemResource resource) {
            int slotLimit = this.slot.countLimit == 0 ? 99 : this.slot.countLimit;
            return resource.isEmpty() ? slotLimit : Math.min(slotLimit, resource.getMaxStackSize());
        }

        @Override
        protected void onRootCommit(ItemStack originalState) {
            this.this$0.entity.onEquipItem(this.slot, originalState, this.getStack());
        }

        @Override
        public String toString() {
            return "entity equipment wrapper[entity=" + String.valueOf(this.this$0.entity) + ",slot=" + String.valueOf(this.slot) + "]";
        }
    }
}

