/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.world.clock.ServerClockManager;
import net.minecraft.world.level.gamerules.GameRules;
import net.neoforged.neoforge.server.command.CommandUtils;

class TimeSpeedCommand {
    TimeSpeedCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"day").then(((LiteralArgumentBuilder)Commands.literal((String)"speed").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.literal((String)"default").executes(context -> TimeSpeedCommand.setDefault((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"realtime").executes(context -> TimeSpeedCommand.setDaylength((CommandSourceStack)context.getSource(), 1440)))).then(Commands.argument((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).executes(context -> TimeSpeedCommand.setSpeed((CommandSourceStack)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"speed")))))).executes(context -> TimeSpeedCommand.query((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"length").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.literal((String)"default").executes(context -> TimeSpeedCommand.setDefault((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"realtime").executes(context -> TimeSpeedCommand.setDaylength((CommandSourceStack)context.getSource(), 1440)))).then(Commands.argument((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1440)).executes(context -> TimeSpeedCommand.setDaylength((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"minutes")))))).executes(context -> TimeSpeedCommand.query((CommandSourceStack)context.getSource())))).executes(context -> TimeSpeedCommand.query((CommandSourceStack)context.getSource()));
    }

    private static int query(CommandSourceStack source) {
        ServerClockManager clockManager = source.getLevel().clockManager();
        Holder defaultClock = source.getLevel().dimensionType().defaultClock().orElse(null);
        if (defaultClock == null) {
            source.sendFailure((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.query.no_default_clock", TimeSpeedCommand.levelName(source)));
            return 1;
        }
        float speed = clockManager.getSpeed(defaultClock);
        if (speed == 1.0f) {
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.query.default", TimeSpeedCommand.levelName(source)), true);
        } else {
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.query", TimeSpeedCommand.levelName(source), Float.valueOf(speed), Float.valueOf(TimeSpeedCommand.minutes(speed))), true);
        }
        return 1;
    }

    private static Component levelName(CommandSourceStack source) {
        return source.getLevel().getDescription();
    }

    private static float minutes(float speed) {
        return (float)((int)(200.0f / speed)) / 10.0f;
    }

    private static int setSpeed(CommandSourceStack source, float speed) {
        GameRules gameRules = source.getLevel().getGameRules();
        Boolean advanceTime = (Boolean)gameRules.get(GameRules.ADVANCE_TIME);
        if (!advanceTime.booleanValue() && speed > 0.0f) {
            gameRules.set(GameRules.ADVANCE_TIME, (Object)true, null);
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.gamerule.set", GameRules.ADVANCE_TIME.id(), gameRules.getAsString(GameRules.ADVANCE_TIME)), true);
        } else if (advanceTime.booleanValue() && speed == 0.0f) {
            gameRules.set(GameRules.ADVANCE_TIME, (Object)false, null);
            source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.gamerule.set", GameRules.ADVANCE_TIME.id(), gameRules.getAsString(GameRules.ADVANCE_TIME)), true);
            return 1;
        }
        ServerClockManager clockManager = source.getLevel().clockManager();
        Holder defaultClock = source.getLevel().dimensionType().defaultClock().orElse(null);
        if (defaultClock == null) {
            source.sendFailure((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.query.no_default_clock", TimeSpeedCommand.levelName(source)));
            return 1;
        }
        clockManager.setSpeed(defaultClock, speed);
        source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.set", TimeSpeedCommand.levelName(source), Float.valueOf(speed), Float.valueOf(TimeSpeedCommand.minutes(speed))), true);
        return 1;
    }

    private static int setDaylength(CommandSourceStack source, int minutes) {
        if (minutes == 20) {
            return TimeSpeedCommand.setDefault(source);
        }
        return TimeSpeedCommand.setSpeed(source, 20.0f / (float)minutes);
    }

    private static int setDefault(CommandSourceStack source) {
        ServerClockManager clockManager = source.getLevel().clockManager();
        Holder defaultClock = source.getLevel().dimensionType().defaultClock().orElse(null);
        if (defaultClock == null) {
            source.sendFailure((Component)CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.query.no_default_clock", TimeSpeedCommand.levelName(source)));
            return 1;
        }
        clockManager.setSpeed(defaultClock, 1.0f);
        source.sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.neoforge.timespeed.set.default", TimeSpeedCommand.levelName(source)), true);
        return 1;
    }
}

