/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public final class ModifyDefaultComponentsEvent
extends Event
implements IModBusEvent {
    private final Map<Item, Consumer<DataComponentMap.Builder>> modifiersByItem;
    private final List<Pair<Predicate<? super Item>, Consumer<DataComponentMap.Builder>>> modifiersByPredicate;

    @ApiStatus.Internal
    public ModifyDefaultComponentsEvent(Map<Item, Consumer<DataComponentMap.Builder>> modifiersByItem, List<Pair<Predicate<? super Item>, Consumer<DataComponentMap.Builder>>> modifiersByPredicate) {
        this.modifiersByItem = modifiersByItem;
        this.modifiersByPredicate = modifiersByPredicate;
    }

    public void modify(ItemLike item, Consumer<DataComponentMap.Builder> patch) {
        this.modifiersByItem.merge(item.asItem(), patch, Consumer::andThen);
    }

    public void modifyMatching(Predicate<? super Item> predicate, Consumer<DataComponentMap.Builder> patch) {
        this.modifiersByPredicate.add((Pair<Predicate<? super Item>, Consumer<DataComponentMap.Builder>>)Pair.of(predicate, patch));
    }
}

