/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.data.event;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public abstract class GatherDataEvent
extends Event
implements IModBusEvent {
    private final DataGenerator dataGenerator;
    private final DataGeneratorConfig config;
    private final ModContainer modContainer;
    private @Nullable CompletableFuture<// Could not load outer class - annotation placement on inner may be incorrect
    HolderLookup.Provider> registriesWithModdedEntries = null;

    public GatherDataEvent(ModContainer mc, DataGenerator dataGenerator, DataGeneratorConfig dataGeneratorConfig) {
        this.modContainer = mc;
        this.dataGenerator = dataGenerator;
        this.config = dataGeneratorConfig;
    }

    public ModContainer getModContainer() {
        return this.modContainer;
    }

    public ResourceManager getResourceManager(PackType packType) {
        return switch (packType) {
            default -> throw new MatchException(null, null);
            case PackType.CLIENT_RESOURCES -> this.config.clientResourceManager;
            case PackType.SERVER_DATA -> this.config.serverResourceManager;
        };
    }

    public Collection<Path> getInputs() {
        return this.config.getInputs();
    }

    public DataGenerator getGenerator() {
        return this.dataGenerator;
    }

    public CompletableFuture<HolderLookup.Provider> getLookupProvider() {
        return Objects.requireNonNullElse(this.registriesWithModdedEntries, this.config.lookupProvider);
    }

    public boolean includeDev() {
        return this.config.dev;
    }

    public boolean includeReports() {
        return this.config.reports;
    }

    public boolean validate() {
        return this.config.validate;
    }

    public <T extends DataProvider> T addProvider(T provider) {
        return (T)this.dataGenerator.addProvider(true, provider);
    }

    public <T extends DataProvider> T createProvider(DataProviderFromOutput<T> builder) {
        return this.addProvider(builder.create(this.dataGenerator.getPackOutput()));
    }

    public <T extends DataProvider> T createProvider(DataProviderFromOutputLookup<T> builder) {
        return this.addProvider(builder.create(this.dataGenerator.getPackOutput(), this.getLookupProvider()));
    }

    public void createBlockAndItemTags(DataProviderFromOutputLookup<TagsProvider<Block>> blockTagsProvider, ItemTagsProvider itemTagsProvider) {
        TagsProvider<Block> blockTags = this.createProvider(blockTagsProvider);
        this.addProvider((DataProvider)itemTagsProvider.create(this.getGenerator().getPackOutput(), this.getLookupProvider(), blockTags.contentsGetter()));
    }

    public void createDatapackRegistryObjects(RegistrySetBuilder datapackEntriesBuilder) {
        this.createDatapackRegistryObjects(datapackEntriesBuilder, Set.of(this.modContainer.getModId()));
    }

    public void createDatapackRegistryObjects(RegistrySetBuilder datapackEntriesBuilder, Set<String> modIds) {
        this.createDatapackRegistryObjects(datapackEntriesBuilder, Consumers.nop(), modIds);
    }

    public void createDatapackRegistryObjects(RegistrySetBuilder datapackEntriesBuilder, Map<ResourceKey<?>, List<ICondition>> conditions) {
        this.createDatapackRegistryObjects(datapackEntriesBuilder, conditions, Set.of(this.modContainer.getModId()));
    }

    public void createDatapackRegistryObjects(RegistrySetBuilder datapackEntriesBuilder, Map<ResourceKey<?>, List<ICondition>> conditions, Set<String> modIds) {
        DatapackBuiltinEntriesProvider registries = this.createProvider((PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) -> new DatapackBuiltinEntriesProvider(output, (CompletableFuture<HolderLookup.Provider>)lookupProvider, datapackEntriesBuilder, conditions, modIds));
        this.registriesWithModdedEntries = registries.getRegistryProvider();
    }

    public void createDatapackRegistryObjects(RegistrySetBuilder datapackEntriesBuilder, Consumer<BiConsumer<ResourceKey<?>, ICondition>> conditionsBuilder) {
        this.createDatapackRegistryObjects(datapackEntriesBuilder, conditionsBuilder, Set.of(this.modContainer.getModId()));
    }

    public void createDatapackRegistryObjects(RegistrySetBuilder datapackEntriesBuilder, Consumer<BiConsumer<ResourceKey<?>, ICondition>> conditionsBuilder, Set<String> modIds) {
        DatapackBuiltinEntriesProvider registries = this.createProvider((PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) -> new DatapackBuiltinEntriesProvider(output, (CompletableFuture<HolderLookup.Provider>)lookupProvider, datapackEntriesBuilder, conditionsBuilder, modIds));
        this.registriesWithModdedEntries = registries.getRegistryProvider();
    }

    @ApiStatus.Internal
    public static class DataGeneratorConfig {
        private final Set<String> mods;
        private final Path path;
        private final Collection<Path> inputs;
        private final CompletableFuture<HolderLookup.Provider> lookupProvider;
        private final boolean dev;
        private final boolean reports;
        private final boolean validate;
        private final boolean flat;
        private final List<DataGenerator> generators = new ArrayList<DataGenerator>();
        private final ResourceManager clientResourceManager;
        private final ResourceManager serverResourceManager;

        public DataGeneratorConfig(Set<String> mods, Path path, Collection<Path> inputs, CompletableFuture<HolderLookup.Provider> lookupProvider, boolean dev, boolean reports, boolean validate, boolean flat, DataGenerator vanillaGenerator, Collection<Path> existingPacks, Consumer<Consumer<PackResources>> vanillaClientAssets) {
            this.mods = mods;
            this.path = path;
            this.inputs = inputs;
            this.lookupProvider = lookupProvider;
            this.dev = dev;
            this.reports = reports;
            this.validate = validate;
            this.flat = flat;
            this.clientResourceManager = DataGeneratorConfig.createResourceManager(PackType.CLIENT_RESOURCES, mods::contains, existingPacks, vanillaClientAssets);
            this.serverResourceManager = DataGeneratorConfig.createResourceManager(PackType.SERVER_DATA, mods::contains, existingPacks, consumer -> consumer.accept(ServerPacksSource.createVanillaPackSource()));
            if (mods.contains("minecraft") || mods.isEmpty()) {
                this.generators.add(vanillaGenerator);
            }
        }

        public Collection<Path> getInputs() {
            return this.inputs;
        }

        public Set<String> getMods() {
            return this.mods;
        }

        public boolean isFlat() {
            return this.flat || this.getMods().size() == 1;
        }

        public DataGenerator makeGenerator(Function<Path, Path> pathEnhancer) {
            DataGenerator.Cached generator = new DataGenerator.Cached(pathEnhancer.apply(this.path), DetectedVersion.tryDetectVersion(), true);
            this.generators.add((DataGenerator)generator);
            return generator;
        }

        public void runAll() {
            Map paths = this.generators.stream().collect(Collectors.groupingBy(gen -> gen.getPackOutput().getOutputFolder(), LinkedHashMap::new, Collectors.toList()));
            paths.values().forEach(lst -> {
                DataGenerator parent = (DataGenerator)lst.get(0);
                for (int x = 1; x < lst.size(); ++x) {
                    parent.merge((DataGenerator)lst.get(x));
                }
                try {
                    parent.run();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }

        private static ResourceManager createResourceManager(PackType packType, Predicate<String> isGeneratedMod, Collection<Path> existingPacks, Consumer<Consumer<PackResources>> consumer) {
            ArrayList packs = Lists.newArrayList();
            consumer.accept(packs::add);
            existingPacks.forEach(path -> {
                PackLocationInfo packInfo = new PackLocationInfo(path.getFileName().toString(), (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty());
                packs.add(new PathPackResources(packInfo, path));
            });
            ModList.get().getSortedMods().stream().filter(Predicate.not(mod -> mod.getModId().equals("minecraft"))).filter(Predicate.not(mod -> isGeneratedMod.test(mod.getModId()))).map(mod -> {
                IModFileInfo owningFile = mod.getModInfo().getOwningFile();
                PackLocationInfo packInfo = new PackLocationInfo("mod/" + mod.getModId(), (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty());
                return ResourcePackLoader.createPackForMod(owningFile).openPrimary(packInfo);
            }).forEach(packs::add);
            return new MultiPackResourceManager(packType, (List)packs);
        }
    }

    @FunctionalInterface
    public static interface DataProviderFromOutput<T extends DataProvider> {
        public T create(PackOutput var1);
    }

    @FunctionalInterface
    public static interface DataProviderFromOutputLookup<T extends DataProvider> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2);
    }

    @FunctionalInterface
    public static interface ItemTagsProvider {
        public TagsProvider<Item> create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, CompletableFuture<TagsProvider.TagLookup<Block>> var3);
    }

    @FunctionalInterface
    public static interface GatherDataEventGenerator {
        public GatherDataEvent create(ModContainer var1, DataGenerator var2, DataGeneratorConfig var3);
    }

    public static class Client
    extends GatherDataEvent {
        public Client(ModContainer mc, DataGenerator dataGenerator, DataGeneratorConfig dataGeneratorConfig) {
            super(mc, dataGenerator, dataGeneratorConfig);
        }
    }

    public static class Server
    extends GatherDataEvent {
        public Server(ModContainer mc, DataGenerator dataGenerator, DataGeneratorConfig dataGeneratorConfig) {
            super(mc, dataGenerator, dataGeneratorConfig);
        }
    }
}

