/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackTemplate;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class DataComponentIngredient
implements ICustomIngredient {
    public static final MapCodec<DataComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(DataComponentIngredient::itemSet), (App)DataComponentPatch.CODEC.fieldOf("components").forGetter(DataComponentIngredient::components), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(DataComponentIngredient::componentsExhaustive)).apply((Applicative)builder, DataComponentIngredient::new));
    private final HolderSet<Item> items;
    private final DataComponentPatch components;
    private final boolean exhaustive;

    public DataComponentIngredient(HolderSet<Item> items, DataComponentPatch components, boolean exhaustive) {
        this.items = items;
        this.components = components;
        this.exhaustive = exhaustive;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (!this.items.contains(stack.typeHolder()) || !this.testComponents((DataComponentGetter)stack)) {
            return false;
        }
        if (this.exhaustive) {
            for (DataComponentType type : stack.getComponents().keySet()) {
                if (this.components.getPatch(type) != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean testComponents(DataComponentGetter getter) {
        for (Map.Entry entry : this.components.entrySet()) {
            DataComponentType type = (DataComponentType)entry.getKey();
            Optional value = (Optional)entry.getValue();
            if ((!value.isEmpty() || !getter.has(type)) && (!value.isPresent() || value.get().equals(getter.get(type)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Stream<Holder<Item>> items() {
        return this.items.stream();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IngredientType<?> getType() {
        return NeoForgeMod.DATA_COMPONENT_INGREDIENT_TYPE.get();
    }

    @Override
    public SlotDisplay display() {
        return new SlotDisplay.Composite(this.items.stream().map(item -> {
            ItemStackTemplate template = new ItemStackTemplate(item, 1, this.components);
            SlotDisplay.ItemStackSlotDisplay display = new SlotDisplay.ItemStackSlotDisplay(template);
            ItemStackTemplate remainder = ((Item)item.value()).getCraftingRemainder((ItemInstance)template);
            if (remainder != null) {
                SlotDisplay.ItemStackSlotDisplay remainderDisplay = new SlotDisplay.ItemStackSlotDisplay(remainder);
                return new SlotDisplay.WithRemainder((SlotDisplay)display, (SlotDisplay)remainderDisplay);
            }
            return display;
        }).toList());
    }

    public HolderSet<Item> itemSet() {
        return this.items;
    }

    public DataComponentPatch components() {
        return this.components;
    }

    public boolean componentsExhaustive() {
        return this.exhaustive;
    }

    @Deprecated(forRemoval=true)
    public boolean isStrict() {
        return this.exhaustive;
    }

    public static Ingredient of(boolean exhaustive, ItemStack stack) {
        return DataComponentIngredient.of(exhaustive, stack.getComponents(), new ItemLike[]{stack.getItem()});
    }

    public static Ingredient of(boolean exhaustive, ItemStackTemplate stack) {
        return DataComponentIngredient.of(exhaustive, stack.components(), stack.item());
    }

    public static <T> Ingredient of(DataComponentType<? super T> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(false, DataComponentPatch.builder().set(type, value).build(), items);
    }

    public static <T> Ingredient of(boolean exhaustive, DataComponentType<? super T> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(exhaustive, DataComponentPatch.builder().set(type, value).build(), items);
    }

    public static <T> Ingredient of(boolean exhaustive, Supplier<? extends DataComponentType<? super T>> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(exhaustive, type.get(), value, items);
    }

    public static Ingredient of(boolean exhaustive, DataComponentMap map, ItemLike ... items) {
        return DataComponentIngredient.of(exhaustive, DataComponentIngredient.asPatch(map), items);
    }

    @SafeVarargs
    public static Ingredient of(boolean exhaustive, DataComponentMap map, Holder<Item> ... items) {
        return DataComponentIngredient.of(exhaustive, DataComponentIngredient.asPatch(map), items);
    }

    public static Ingredient of(boolean exhaustive, DataComponentMap map, HolderSet<Item> items) {
        return DataComponentIngredient.of(exhaustive, DataComponentIngredient.asPatch(map), items);
    }

    private static DataComponentPatch asPatch(DataComponentMap map) {
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        for (TypedDataComponent type : map) {
            builder.set(type);
        }
        return builder.build();
    }

    @SafeVarargs
    public static Ingredient of(boolean exhaustive, DataComponentPatch predicate, Holder<Item> ... items) {
        return DataComponentIngredient.of(exhaustive, predicate, (HolderSet<Item>)HolderSet.direct(items));
    }

    public static Ingredient of(DataComponentPatch predicate, ItemLike ... items) {
        return DataComponentIngredient.of(false, predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    public static Ingredient of(boolean exhaustive, DataComponentPatch predicate, ItemLike ... items) {
        return DataComponentIngredient.of(exhaustive, predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    public static Ingredient of(boolean exhaustive, DataComponentPatch predicate, HolderSet<Item> items) {
        return new DataComponentIngredient(items, predicate, exhaustive).toVanilla();
    }
}

