/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.internal;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public class NeoForgeProxy {
    public static final NeoForgeProxy INSTANCE = NeoForgeProxy.instantiate();

    private static NeoForgeProxy instantiate() {
        NeoForgeProxy neoForgeProxy;
        switch (FMLEnvironment.getDist()) {
            default: {
                throw new MatchException(null, null);
            }
            case CLIENT: {
                try {
                    NeoForgeProxy neoForgeProxy2;
                    neoForgeProxy = neoForgeProxy2 = (NeoForgeProxy)Class.forName("net.neoforged.neoforge.client.internal.NeoForgeClientProxy").getConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to instantiate client proxy", e);
                }
            }
            case DEDICATED_SERVER: {
                NeoForgeProxy neoForgeProxy3;
                neoForgeProxy = neoForgeProxy3 = new NeoForgeProxy();
            }
        }
        return neoForgeProxy;
    }

    public BlockableEventLoop<Runnable> getClientExecutor() {
        throw new UnsupportedOperationException("Cannot access client on the server");
    }

    public TooltipFlag getTooltipFlag() {
        return TooltipFlag.NORMAL;
    }

    public <T> // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HolderLookup.RegistryLookup<T> resolveLookup(ResourceKey<? extends Registry<T>> key) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.registryAccess().lookup(key).orElse(null);
        }
        return null;
    }
}

