/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.clock.ClockTimeMarker;
import net.minecraft.world.clock.ServerClockManager;
import net.minecraft.world.clock.WorldClock;

public sealed interface ClockAdjustment {
    public void apply(ServerClockManager var1, Holder<WorldClock> var2);

    public record Marker(ResourceKey<ClockTimeMarker> marker) implements ClockAdjustment
    {
        public Marker {
            Objects.requireNonNull(marker);
        }

        @Override
        public void apply(ServerClockManager clockManager, Holder<WorldClock> clock) {
            clockManager.skipToTimeMarker(clock, this.marker);
        }
    }

    public record Relative(long ticks) implements ClockAdjustment
    {
        @Override
        public void apply(ServerClockManager clockManager, Holder<WorldClock> clock) {
            long currentTicks = clockManager.getTotalTicks(clock);
            long newTicks = currentTicks + this.ticks;
            clockManager.setTotalTicks(clock, newTicks);
        }
    }

    public record Absolute(long ticks) implements ClockAdjustment
    {
        @Override
        public void apply(ServerClockManager clockManager, Holder<WorldClock> clock) {
            clockManager.setTotalTicks(clock, this.ticks);
        }
    }
}

