/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public interface IBlockGetterExtension {
    @ApiStatus.NonExtendable
    default public @Nullable AuxiliaryLightManager getAuxLightManager(BlockPos pos) {
        return this.getAuxLightManager(ChunkPos.containing((BlockPos)pos));
    }

    default public @Nullable AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        IBlockGetterExtension iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof LevelAccessor) {
            LevelAccessor level = (LevelAccessor)iBlockGetterExtension;
            LightChunk chunk = level.getChunkSource().getChunkForLighting(pos.x(), pos.z());
            return chunk != null ? chunk.getAuxLightManager(pos) : null;
        }
        iBlockGetterExtension = this;
        if (iBlockGetterExtension instanceof ImposterProtoChunk) {
            ImposterProtoChunk chunk = (ImposterProtoChunk)iBlockGetterExtension;
            return chunk.getWrapped().getAuxLightManager(pos);
        }
        return null;
    }

    default public ModelData getModelData(BlockPos pos) {
        return ModelData.EMPTY;
    }
}

