/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;

public final class NeoForgeDamageTypeTagsProvider
extends DamageTypeTagsProvider {
    private final Map<Identifier, TagBuilder> vanillaBuilders = Maps.newLinkedHashMap();
    private boolean inVanilla;

    public NeoForgeDamageTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider, "neoforge");
    }

    protected TagAppender<ResourceKey<DamageType>, DamageType> tag(TagKey<DamageType> tag) {
        if (this.inVanilla) {
            return TagAppender.forBuilder((TagBuilder)this.vanillaBuilders.computeIfAbsent(tag.location(), location -> TagBuilder.create()));
        }
        return super.tag(tag);
    }

    protected void addTags(HolderLookup.Provider lookupProvider) {
        this.inVanilla = true;
        super.addTags(lookupProvider);
        this.inVanilla = false;
        this.tag(Tags.DamageTypes.IS_POISON).addOptional(NeoForgeMod.POISON_DAMAGE);
        this.tag((ResourceKey<DamageType>)DamageTypes.WITHER, Tags.DamageTypes.IS_WITHER);
        this.tag((ResourceKey<DamageType>)DamageTypes.WITHER_SKULL, Tags.DamageTypes.IS_WITHER);
        this.tag((ResourceKey<DamageType>)DamageTypes.MAGIC, Tags.DamageTypes.IS_MAGIC);
        this.tag((ResourceKey<DamageType>)DamageTypes.INDIRECT_MAGIC, Tags.DamageTypes.IS_MAGIC);
        this.tag((ResourceKey<DamageType>)DamageTypes.THORNS, Tags.DamageTypes.IS_MAGIC);
        this.tag((ResourceKey<DamageType>)DamageTypes.DRAGON_BREATH, Tags.DamageTypes.IS_MAGIC);
        this.tag(Tags.DamageTypes.IS_MAGIC).addTags(new TagKey[]{Tags.DamageTypes.IS_POISON, Tags.DamageTypes.IS_WITHER});
        this.addAsVanilla((ResourceKey<DamageType>)DamageTypes.MAGIC).addTags(new TagKey[]{Tags.DamageTypes.IS_POISON});
        this.tag((ResourceKey<DamageType>)DamageTypes.IN_FIRE, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.ON_FIRE, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.LAVA, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.HOT_FLOOR, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.DROWN, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.STARVE, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.DRY_OUT, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.FREEZE, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.LIGHTNING_BOLT, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.CACTUS, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.STALAGMITE, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALLING_STALACTITE, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALLING_BLOCK, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALLING_ANVIL, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.CRAMMING, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.FLY_INTO_WALL, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.SWEET_BERRY_BUSH, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.IN_WALL, Tags.DamageTypes.IS_ENVIRONMENT);
        this.tag((ResourceKey<DamageType>)DamageTypes.CACTUS, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.STALAGMITE, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALLING_STALACTITE, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALLING_BLOCK, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALLING_ANVIL, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.CRAMMING, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.FLY_INTO_WALL, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.SWEET_BERRY_BUSH, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.FALL, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.STING, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.MOB_ATTACK, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.PLAYER_ATTACK, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.MOB_ATTACK_NO_AGGRO, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.ARROW, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.THROWN, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.TRIDENT, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.MOB_PROJECTILE, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.SONIC_BOOM, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.IN_WALL, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.GENERIC, Tags.DamageTypes.IS_PHYSICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.GENERIC_KILL, Tags.DamageTypes.IS_TECHNICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.OUTSIDE_BORDER, Tags.DamageTypes.IS_TECHNICAL);
        this.tag((ResourceKey<DamageType>)DamageTypes.FELL_OUT_OF_WORLD, Tags.DamageTypes.IS_TECHNICAL);
        this.tag(Tags.DamageTypes.NO_FLINCH);
    }

    private TagAppender<ResourceKey<DamageType>, DamageType> addAsVanilla(ResourceKey<DamageType> entry) {
        final ArrayList builders = new ArrayList();
        this.vanillaBuilders.forEach((location, tagBuilder) -> {
            if (tagBuilder.build().stream().anyMatch(tagEntry -> tagEntry.verifyIfPresent(element -> element.equals((Object)entry.identifier()), tag -> false))) {
                builders.add(this.getOrCreateRawBuilder(TagKey.create((ResourceKey)this.registryKey, (Identifier)location)));
            }
        });
        return TagAppender.forBuilder((TagBuilder)new TagBuilder(this){
            {
                Objects.requireNonNull(this$0);
            }

            public TagBuilder add(TagEntry entry) {
                builders.forEach(builder -> builder.add(entry));
                return super.add(entry);
            }
        });
    }

    @SafeVarargs
    private void tag(ResourceKey<DamageType> type, TagKey<DamageType> ... tags) {
        for (TagKey<DamageType> key : tags) {
            this.tag(key).add(type);
        }
    }

    private TagAppender<ResourceKey<DamageType>, DamageType> tagWithOptionalLegacy(TagKey<DamageType> tag) {
        TagAppender<ResourceKey<DamageType>, DamageType> tagAppender = this.tag(tag);
        tagAppender.addOptionalTag(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (Identifier)Identifier.fromNamespaceAndPath((String)"forge", (String)tag.location().getPath())));
        return tagAppender;
    }

    public String getName() {
        return "NeoForge Damage Type Tags";
    }
}

