/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMaps;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.BaseMappedRegistry;
import org.jspecify.annotations.Nullable;

public class RegistrySnapshot {
    private static final Comparator<Identifier> SORTER = Identifier::compareNamespaced;
    public static final StreamCodec<FriendlyByteBuf, RegistrySnapshot> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, RegistrySnapshot>(){

        public RegistrySnapshot decode(FriendlyByteBuf buf) {
            RegistrySnapshot snapshot = new RegistrySnapshot();
            buf.readMap(size -> snapshot.ids, FriendlyByteBuf::readVarInt, FriendlyByteBuf::readIdentifier);
            buf.readMap(size -> snapshot.aliases, FriendlyByteBuf::readIdentifier, FriendlyByteBuf::readIdentifier);
            return snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void encode(FriendlyByteBuf buf, RegistrySnapshot snapshot) {
            if (snapshot.binary == null) {
                FriendlyByteBuf pkt = new FriendlyByteBuf(Unpooled.buffer());
                try {
                    pkt.writeMap(snapshot.ids, FriendlyByteBuf::writeVarInt, FriendlyByteBuf::writeIdentifier);
                    pkt.writeMap(snapshot.aliases, FriendlyByteBuf::writeIdentifier, FriendlyByteBuf::writeIdentifier);
                    snapshot.binary = new byte[pkt.readableBytes()];
                    pkt.readBytes(snapshot.binary);
                }
                finally {
                    pkt.release();
                }
            }
            buf.writeBytes(snapshot.binary);
        }
    };
    private final Int2ObjectSortedMap<Identifier> ids = new Int2ObjectRBTreeMap();
    private final Int2ObjectSortedMap<Identifier> idsView = Int2ObjectSortedMaps.unmodifiable(this.ids);
    private final Map<Identifier, Identifier> aliases = new TreeMap<Identifier, Identifier>(SORTER);
    private final Map<Identifier, Identifier> aliasesView = Collections.unmodifiableMap(this.aliases);
    private final @Nullable Registry<?> fullBackup;
    private @Nullable byte[] binary = null;

    private RegistrySnapshot() {
        this.fullBackup = null;
    }

    public <T> RegistrySnapshot(Registry<T> registry, boolean full) {
        registry.keySet().forEach(key -> this.ids.put(registry.getId(key), key));
        this.aliases.putAll(((BaseMappedRegistry)registry).aliases);
        if (full) {
            MappedRegistry backup = new MappedRegistry(registry.key(), registry.registryLifecycle());
            for (Map.Entry entry : registry.entrySet()) {
                ResourceKey key2 = (ResourceKey)entry.getKey();
                Object value = entry.getValue();
                backup.register(registry.getId(key2), key2, value, registry.registrationInfo(key2).orElse(RegistrationInfo.BUILT_IN));
            }
            backup.freeze();
            this.fullBackup = backup;
        } else {
            this.fullBackup = null;
        }
    }

    public Int2ObjectSortedMap<Identifier> getIds() {
        return this.idsView;
    }

    public Map<Identifier, Identifier> getAliases() {
        return this.aliasesView;
    }

    public <T> @Nullable Registry<T> getFullBackup() {
        return this.fullBackup;
    }
}

