/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public interface IItemExtension {
    private Item self() {
        return (Item)this;
    }

    default public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return ItemAttributeModifiers.EMPTY;
    }

    default public boolean onDroppedByPlayer(ItemStack item, Player player) {
        return true;
    }

    default public Component getHighlightTip(ItemStack item, Component displayName) {
        return displayName;
    }

    default public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean isPiglinCurrency(ItemStack stack) {
        return stack.getItem() == PiglinAi.BARTERING_ITEM;
    }

    default public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.is(ItemTags.PIGLIN_SAFE_ARMOR);
    }

    public boolean isCombineRepairable(ItemStack var1);

    default public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    default public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
    }

    default public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return false;
    }

    default public ItemStack getCraftingRemainder(ItemStack itemStack) {
        return this.self().getCraftingRemainder();
    }

    default public int getEntityLifespan(ItemStack itemStack, Level level) {
        return 6000;
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    default public @Nullable Entity createEntity(Level level, Entity location, ItemStack stack) {
        return null;
    }

    default public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return false;
    }

    default public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    default public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return entity.isEquippableInSlot(stack, armorType);
    }

    default public @Nullable EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return null;
    }

    default public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return false;
    }

    default public int getDamage(ItemStack stack) {
        return Mth.clamp((int)((Integer)stack.getOrDefault(DataComponents.DAMAGE, (Object)0)), (int)0, (int)stack.getMaxDamage());
    }

    default public int getMaxDamage(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.MAX_DAMAGE, (Object)0);
    }

    default public boolean isDamaged(ItemStack stack) {
        return stack.getDamageValue() > 0;
    }

    default public void setDamage(ItemStack stack, int damage) {
        stack.set(DataComponents.DAMAGE, (Object)Mth.clamp((int)damage, (int)0, (int)stack.getMaxDamage()));
    }

    default public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        if (itemAbility == ItemAbilities.SWORD_SWEEP) {
            return stack.is(ItemTags.SWORDS);
        }
        return false;
    }

    default public int getMaxStackSize(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
    }

    @ApiStatus.OverrideOnly
    default public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (stack.getItem() == Items.BOOK) {
            return true;
        }
        Optional primaryItems = ((Enchantment)enchantment.value()).definition().primaryItems();
        return this.supportsEnchantment(stack, enchantment) && (primaryItems.isEmpty() || stack.is((HolderSet)primaryItems.get()));
    }

    @ApiStatus.OverrideOnly
    default public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return stack.is((Object)Items.ENCHANTED_BOOK) || ((Enchantment)enchantment.value()).isSupportedItem(stack);
    }

    @ApiStatus.OverrideOnly
    default public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        ItemEnchantments itemenchantments = stack.getTagEnchantments();
        return itemenchantments.getLevel(enchantment);
    }

    @ApiStatus.OverrideOnly
    default public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return stack.getTagEnchantments();
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack != newStack;
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (!newStack.is((Object)oldStack.getItem())) {
            return true;
        }
        if (!newStack.isDamageableItem() || !oldStack.isDamageableItem()) {
            return !ItemStack.isSameItemSameComponents((ItemStack)newStack, (ItemStack)oldStack);
        }
        DataComponentMap newComponents = newStack.getComponents();
        DataComponentMap oldComponents = oldStack.getComponents();
        if (newComponents.isEmpty() || oldComponents.isEmpty()) {
            return !newComponents.isEmpty() || !oldComponents.isEmpty();
        }
        HashSet newKeys = new HashSet(newComponents.keySet());
        HashSet oldKeys = new HashSet(oldComponents.keySet());
        newKeys.remove(DataComponents.DAMAGE);
        oldKeys.remove(DataComponents.DAMAGE);
        if (!newKeys.equals(oldKeys)) {
            return true;
        }
        return !newKeys.stream().allMatch(key -> Objects.equals(newComponents.get(key), oldComponents.get(key)));
    }

    default public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (oldStack == newStack) {
            return true;
        }
        return !oldStack.isEmpty() && !newStack.isEmpty() && ItemStack.isSameItem((ItemStack)newStack, (ItemStack)oldStack);
    }

    default public @Nullable String getCreatorModId(HolderLookup.Provider registries, ItemStack itemStack) {
        return CommonHooks.getDefaultCreatorModId(registries, itemStack);
    }

    @ApiStatus.OverrideOnly
    default public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        return fuelValues.burnDuration(itemStack);
    }

    @ApiStatus.OverrideOnly
    default public void onAnimalArmorTick(ItemStack stack, Level level, Mob horse) {
    }

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return amount;
    }

    default public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        this.self().onDestroyed(itemEntity);
    }

    default public boolean isGazeDisguise(ItemStack stack, Player player, @Nullable LivingEntity entity) {
        return stack.is(ItemTags.GAZE_DISGUISE_EQUIPMENT);
    }

    default public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is((Object)Items.LEATHER_BOOTS);
    }

    default public boolean isDamageable(ItemStack stack) {
        return stack.has(DataComponents.MAX_DAMAGE);
    }

    default public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        return target.getBoundingBox().inflate(1.0, 0.25, 1.0);
    }

    default public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return stack.isEnchanted();
    }

    default public boolean canGrindstoneRepair(ItemStack stack) {
        return false;
    }

    default public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return true;
    }

    default public ItemStack applyEnchantments(ItemStack stack, List<EnchantmentInstance> enchantments) {
        if (stack.is((Object)Items.BOOK)) {
            stack = stack.transmuteCopy((ItemLike)Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance inst : enchantments) {
            stack.enchant(inst.enchantment(), inst.level());
        }
        return stack;
    }

    default public boolean canFitInsideContainerItems(ItemStack stack) {
        return this.self().canFitInsideContainerItems();
    }
}

