/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.registries.DataMapLoader;
import net.neoforged.neoforge.registries.datamaps.AdvancedDataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapEntry;
import net.neoforged.neoforge.registries.datamaps.DataMapFile;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;

public abstract class DataMapProvider
implements DataProvider {
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final PackOutput.PathProvider pathProvider;
    private final Map<DataMapType<?, ?>, Builder<?, ?>> builders = new HashMap();

    protected DataMapProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "data_maps");
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.lookupProvider.thenCompose(provider -> {
            this.gather((HolderLookup.Provider)provider);
            RegistryOps dynamicOps = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(arg_0 -> this.lambda$run$1(cache, (DynamicOps)dynamicOps, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T, R> CompletableFuture<?> generate(Path out, CachedOutput cache, Builder<T, R> builder, DynamicOps<JsonElement> ops) {
        return CompletableFuture.supplyAsync(() -> {
            Codec withConditionsCodec = ConditionalOps.createConditionalCodecWithConditions(DataMapFile.codec(builder.registryKey, builder.type));
            return (JsonElement)withConditionsCodec.encodeStart(ops, Optional.of(builder.build())).getOrThrow(msg -> new RuntimeException("Failed to encode %s: %s".formatted(out, msg)));
        }).thenComposeAsync(encoded -> DataProvider.saveStable((CachedOutput)cache, (JsonElement)encoded, (Path)out));
    }

    protected abstract void gather(HolderLookup.Provider var1);

    public <T, R> Builder<T, R> builder(DataMapType<R, T> type) {
        if (type instanceof AdvancedDataMapType) {
            AdvancedDataMapType advanced = (AdvancedDataMapType)type;
            return this.builder(advanced);
        }
        return this.builders.computeIfAbsent(type, k -> new Builder(type));
    }

    public <T, R, VR extends DataMapValueRemover<R, T>> AdvancedBuilder<T, R, VR> builder(AdvancedDataMapType<R, T, VR> type) {
        return (AdvancedBuilder)this.builders.computeIfAbsent(type, k -> new AdvancedBuilder(type));
    }

    public String getName() {
        return "Data Maps";
    }

    private /* synthetic */ CompletableFuture lambda$run$1(CachedOutput cache, DynamicOps dynamicOps, Map.Entry entry) {
        DataMapType type = (DataMapType)entry.getKey();
        Path path = this.pathProvider.json(type.id().withPrefix(DataMapLoader.getFolderLocation(type.registryKey().identifier()) + "/"));
        return this.generate(path, cache, (Builder)entry.getValue(), (DynamicOps<JsonElement>)dynamicOps);
    }

    public static class Builder<T, R> {
        private final Map<Either<TagKey<R>, ResourceKey<R>>, Optional<WithConditions<DataMapEntry<T>>>> values = new LinkedHashMap<Either<TagKey<R>, ResourceKey<R>>, Optional<WithConditions<DataMapEntry<T>>>>();
        protected final List<DataMapEntry.Removal<T, R>> removals = new ArrayList<DataMapEntry.Removal<T, R>>();
        protected final ResourceKey<Registry<R>> registryKey;
        private final DataMapType<R, T> type;
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private boolean replace;

        public Builder(DataMapType<R, T> type) {
            this.type = type;
            this.registryKey = type.registryKey();
        }

        public Builder<T, R> add(ResourceKey<R> key, T value, boolean replace, ICondition ... conditions) {
            this.values.put(Either.right(key), Optional.of(new WithConditions<DataMapEntry<T>>(new DataMapEntry<T>(value, replace), conditions)));
            return this;
        }

        public Builder<T, R> add(Identifier id, T value, boolean replace, ICondition ... conditions) {
            return this.add(ResourceKey.create(this.registryKey, (Identifier)id), value, replace, conditions);
        }

        public Builder<T, R> add(Holder<R> object, T value, boolean replace, ICondition ... conditions) {
            return this.add((ResourceKey)object.unwrapKey().orElseThrow(), value, replace, conditions);
        }

        public Builder<T, R> add(TagKey<R> tag, T value, boolean replace, ICondition ... conditions) {
            this.values.put(Either.left(tag), Optional.of(new WithConditions<DataMapEntry<T>>(new DataMapEntry<T>(value, replace), conditions)));
            return this;
        }

        public Builder<T, R> remove(Identifier id) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)ResourceKey.create(this.registryKey, (Identifier)id)), Optional.empty()));
            return this;
        }

        public Builder<T, R> remove(TagKey<R> tag) {
            this.removals.add(new DataMapEntry.Removal(Either.left(tag), Optional.empty()));
            return this;
        }

        public Builder<T, R> remove(Holder<R> value) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)((ResourceKey)value.unwrap().orThrow())), Optional.empty()));
            return this;
        }

        public Builder<T, R> replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public Builder<T, R> conditions(ICondition ... conditions) {
            Collections.addAll(this.conditions, conditions);
            return this;
        }

        public WithConditions<DataMapFile<T, R>> build() {
            return new WithConditions<DataMapFile<T, R>>(this.conditions, new DataMapFile<T, R>(this.replace, this.values, this.removals));
        }
    }

    public static class AdvancedBuilder<T, R, VR extends DataMapValueRemover<R, T>>
    extends Builder<T, R> {
        public AdvancedBuilder(AdvancedDataMapType<R, T, VR> type) {
            super(type);
        }

        public AdvancedBuilder<T, R, VR> remove(TagKey<R> tag, VR remover) {
            this.removals.add(new DataMapEntry.Removal(Either.left(tag), Optional.of(remover)));
            return this;
        }

        public AdvancedBuilder<T, R, VR> remove(Holder<R> value, VR remover) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)((ResourceKey)value.unwrap().orThrow())), Optional.of(remover)));
            return this;
        }

        public AdvancedBuilder<T, R, VR> remove(Identifier id, VR remover) {
            this.removals.add(new DataMapEntry.Removal(Either.right((Object)ResourceKey.create((ResourceKey)this.registryKey, (Identifier)id)), Optional.of(remover)));
            return this;
        }
    }
}

