/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentSync;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.client.registries.ClientRegistryManager;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.common.world.LevelChunkAuxiliaryLightManager;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.ConfigSync;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.AdvancedAddEntityPayload;
import net.neoforged.neoforge.network.payload.AdvancedContainerSetDataPayload;
import net.neoforged.neoforge.network.payload.AdvancedOpenScreenPayload;
import net.neoforged.neoforge.network.payload.AuxiliaryLightDataPayload;
import net.neoforged.neoforge.network.payload.ClientboundCustomSetTimePayload;
import net.neoforged.neoforge.network.payload.ConfigFilePayload;
import net.neoforged.neoforge.network.payload.FrozenRegistryPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncCompletedPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncStartPayload;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsPayload;
import net.neoforged.neoforge.network.payload.RecipeContentPayload;
import net.neoforged.neoforge.network.payload.RegistryDataMapSyncPayload;
import net.neoforged.neoforge.network.payload.SyncAttachmentsPayload;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.RegistrySnapshot;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="neoforge", value={Dist.CLIENT})
@ApiStatus.Internal
final class ClientPayloadHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientPayloadHandler.class);
    private static final Set<Identifier> toSynchronize = Sets.newConcurrentHashSet();
    private static final Map<Identifier, RegistrySnapshot> synchronizedRegistries = Maps.newConcurrentMap();

    private ClientPayloadHandler() {
    }

    @SubscribeEvent
    private static void register(RegisterClientPayloadHandlersEvent event) {
        event.register(ConfigFilePayload.TYPE, ClientPayloadHandler::handle);
        event.register(FrozenRegistrySyncStartPayload.TYPE, ClientPayloadHandler::handle);
        event.register(FrozenRegistryPayload.TYPE, ClientPayloadHandler::handle);
        event.register(FrozenRegistrySyncCompletedPayload.TYPE, ClientPayloadHandler::handle);
        event.register(KnownRegistryDataMapsPayload.TYPE, ClientRegistryManager::handleKnownDataMaps);
        event.register(AdvancedAddEntityPayload.TYPE, ClientPayloadHandler::handle);
        event.register(AdvancedOpenScreenPayload.TYPE, ClientPayloadHandler::handle);
        event.register(AuxiliaryLightDataPayload.TYPE, ClientPayloadHandler::handle);
        event.register(RegistryDataMapSyncPayload.TYPE, ClientRegistryManager::handleDataMapSync);
        event.register(AdvancedContainerSetDataPayload.TYPE, ClientPayloadHandler::handle);
        event.register(ClientboundCustomSetTimePayload.TYPE, ClientPayloadHandler::handle);
        event.register(RecipeContentPayload.TYPE, ClientPayloadHandler::handle);
        event.register(SyncAttachmentsPayload.TYPE, ClientPayloadHandler::handle);
    }

    private static void handle(FrozenRegistryPayload payload, IPayloadContext context) {
        synchronizedRegistries.put(payload.registryName(), payload.snapshot());
        toSynchronize.remove(payload.registryName());
    }

    private static void handle(FrozenRegistrySyncStartPayload payload, IPayloadContext context) {
        toSynchronize.addAll(payload.toAccess());
        synchronizedRegistries.clear();
    }

    private static void handle(FrozenRegistrySyncCompletedPayload payload, IPayloadContext context) {
        if (!toSynchronize.isEmpty()) {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.missing", (Object[])new Object[]{toSynchronize.stream().map(Object::toString).collect(Collectors.joining(", "))}));
            return;
        }
        try {
            Set<ResourceKey<?>> keysUnknownToClient = RegistryManager.applySnapshot(synchronizedRegistries, false);
            if (!keysUnknownToClient.isEmpty()) {
                context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.server-with-unknown-keys", (Object[])new Object[]{keysUnknownToClient.stream().map(Object::toString).collect(Collectors.joining(", "))}));
                return;
            }
            toSynchronize.clear();
            synchronizedRegistries.clear();
            context.reply(FrozenRegistrySyncCompletedPayload.INSTANCE);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle registry sync from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.failed", (Object[])new Object[]{t.toString()}));
        }
    }

    private static void handle(ConfigFilePayload payload, IPayloadContext context) {
        if (!context.connection().isMemoryConnection()) {
            ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(AdvancedAddEntityPayload advancedAddEntityPayload, IPayloadContext context) {
        block5: {
            try {
                Entity entity = context.player().level().getEntity(advancedAddEntityPayload.entityId());
                if (!(entity instanceof IEntityWithComplexSpawn)) break block5;
                IEntityWithComplexSpawn entityAdditionalSpawnData = (IEntityWithComplexSpawn)entity;
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])advancedAddEntityPayload.customPayload()), entity.registryAccess(), context.listener().getConnectionType());
                try {
                    entityAdditionalSpawnData.readSpawnData(buf);
                }
                finally {
                    buf.release();
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to handle advanced add entity from server.", t);
                context.disconnect((Component)Component.translatable((String)"neoforge.network.advanced_add_entity.failed", (Object[])new Object[]{t.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(AdvancedOpenScreenPayload msg, IPayloadContext context) {
        Minecraft mc = Minecraft.getInstance();
        RegistryAccess registryAccess = mc.player.registryAccess();
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])msg.additionalData()), registryAccess, context.listener().getConnectionType());
        try {
            ClientPayloadHandler.createMenuScreen(msg.name(), msg.menuType(), msg.windowId(), buf);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle advanced open screen from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.advanced_open_screen.failed", (Object[])new Object[]{t.toString()}));
        }
        finally {
            buf.release();
        }
    }

    private static <T extends AbstractContainerMenu> void createMenuScreen(Component name, MenuType<T> menuType, int windowId, RegistryFriendlyByteBuf buf) {
        Minecraft mc = Minecraft.getInstance();
        MenuScreens.getScreenFactory(menuType).ifPresent(f -> {
            Screen s = f.create(menuType.create(windowId, mc.player.getInventory(), buf), mc.player.getInventory(), name);
            mc.player.containerMenu = ((MenuAccess)s).getMenu();
            mc.setScreen(s);
        });
    }

    private static void handle(AuxiliaryLightDataPayload msg, IPayloadContext context) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            AuxiliaryLightManager lightManager = mc.level.getAuxLightManager(msg.pos());
            if (lightManager instanceof LevelChunkAuxiliaryLightManager) {
                LevelChunkAuxiliaryLightManager manager = (LevelChunkAuxiliaryLightManager)lightManager;
                manager.handleLightDataSync(msg.entries());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle auxiliary light data from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.aux_light_data.failed", (Object[])new Object[]{msg.pos().toString(), t.toString()}));
        }
    }

    private static void handle(AdvancedContainerSetDataPayload msg, IPayloadContext context) {
        context.handle((Packet<?>)msg.toVanillaPacket());
    }

    private static void handle(ClientboundCustomSetTimePayload payload, IPayloadContext context) {
        ClientLevel level = Minecraft.getInstance().level;
        level.setTimeFromServer(payload.gameTime(), payload.dayTime(), payload.gameRule());
        level.setDayTimeFraction(payload.dayTimeFraction());
        level.setDayTimePerTick(payload.dayTimePerTick());
    }

    private static void handle(RecipeContentPayload payload, IPayloadContext context) {
        RecipeMap recipeMap = RecipeMap.create(payload.recipes());
        NeoForge.EVENT_BUS.post((Event)new RecipesReceivedEvent(payload.recipeTypes(), recipeMap));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void handle(SyncAttachmentsPayload payload, IPayloadContext context) {
        SyncAttachmentsPayload.Target target = payload.target();
        Objects.requireNonNull(target);
        SyncAttachmentsPayload.Target target2 = target;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SyncAttachmentsPayload.BlockEntityTarget.class, SyncAttachmentsPayload.ChunkTarget.class, SyncAttachmentsPayload.EntityTarget.class, SyncAttachmentsPayload.LevelTarget.class}, (SyncAttachmentsPayload.Target)target2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                BlockPos pos;
                SyncAttachmentsPayload.BlockEntityTarget blockEntityTarget = (SyncAttachmentsPayload.BlockEntityTarget)target2;
                try {
                    BlockPos blockPos;
                    pos = blockPos = blockEntityTarget.pos();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                BlockEntity blockEntity = context.player().level().getBlockEntity(pos);
                if (blockEntity == null) {
                    LOGGER.warn("Received synced attachments from unknown block entity");
                    return;
                }
                AttachmentSync.receiveSyncedDataAttachments((AttachmentHolder)blockEntity, context.player().registryAccess(), payload.types(), payload.syncPayload());
                return;
            }
            case 1: {
                SyncAttachmentsPayload.EntityTarget pos;
                SyncAttachmentsPayload.EntityTarget entityTarget;
                SyncAttachmentsPayload.ChunkTarget chunkTarget = (SyncAttachmentsPayload.ChunkTarget)target2;
                {
                    pos = entityTarget = chunkTarget.pos();
                }
                ChunkAccess chunk = context.player().level().getChunk(pos.x(), pos.z(), ChunkStatus.FULL, false);
                if (chunk == null) {
                    LOGGER.warn("Received synced attachments from unknown chunk");
                    return;
                }
                AttachmentSync.receiveSyncedDataAttachments(chunk.getAttachmentHolder(), chunk.getLevel().registryAccess(), payload.types(), payload.syncPayload());
                return;
            }
            case 2: {
                int n2;
                SyncAttachmentsPayload.EntityTarget entityTarget = (SyncAttachmentsPayload.EntityTarget)target2;
                {
                    int n3 = n2 = entityTarget.entity();
                }
                int entityId = n2;
                Entity entity = context.player().level().getEntity(entityId);
                if (entity == null) {
                    LOGGER.warn("Received synced attachments from unknown entity");
                    return;
                }
                AttachmentSync.receiveSyncedDataAttachments((AttachmentHolder)entity, entity.registryAccess(), payload.types(), payload.syncPayload());
                return;
            }
            case 3: 
        }
        SyncAttachmentsPayload.LevelTarget levelTarget = (SyncAttachmentsPayload.LevelTarget)target2;
        AttachmentSync.receiveSyncedDataAttachments((AttachmentHolder)context.player().level(), context.player().registryAccess(), payload.types(), payload.syncPayload());
    }
}

