/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.client.model.AbstractUnbakedModel;
import net.neoforged.neoforge.client.model.CompositeUnbakedGeometry;
import net.neoforged.neoforge.client.model.StandardModelParameters;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;

public class CompositeUnbakedModel
extends AbstractUnbakedModel {
    private final CompositeUnbakedGeometry geometry;

    public CompositeUnbakedModel(StandardModelParameters parameters, CompositeUnbakedGeometry geometry) {
        super(parameters);
        this.geometry = geometry;
    }

    public UnbakedGeometry geometry() {
        return this.geometry;
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        for (Either child : this.geometry.children.values()) {
            child.ifLeft(arg_0 -> ((ResolvableModel.Resolver)resolver).markDependency(arg_0)).ifRight(model -> {
                Identifier parent = model.parent();
                if (parent != null) {
                    resolver.markDependency(parent);
                }
                model.resolveDependencies(resolver);
            });
        }
    }

    public static final class Loader
    implements UnbakedModelLoader<CompositeUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public CompositeUnbakedModel read(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            Loader.readChildren(jsonObject, "children", (ImmutableMap.Builder<String, Either<Identifier, UnbakedModel>>)childrenBuilder, jsonDeserializationContext);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            StandardModelParameters parameters = StandardModelParameters.parse(jsonObject, jsonDeserializationContext);
            return new CompositeUnbakedModel(parameters, new CompositeUnbakedGeometry((ImmutableMap<String, Either<Identifier, UnbakedModel>>)children));
        }

        private static void readChildren(JsonObject jsonObject, String name, ImmutableMap.Builder<String, Either<Identifier, UnbakedModel>> children, JsonDeserializationContext context) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                JsonElement jsonElement;
                Objects.requireNonNull((JsonElement)entry.getValue());
                int n = 0;
                Either child = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonObject.class}, (JsonElement)jsonElement, n)) {
                    case 0 -> {
                        JsonPrimitive reference = (JsonPrimitive)jsonElement;
                        yield Either.left((Object)Identifier.parse((String)reference.getAsString()));
                    }
                    case 1 -> {
                        JsonObject inline = (JsonObject)jsonElement;
                        yield Either.right((Object)((UnbakedModel)context.deserialize((JsonElement)inline, UnbakedModel.class)));
                    }
                    default -> throw new IllegalArgumentException("");
                };
                children.put((Object)((String)entry.getKey()), (Object)child);
            }
        }
    }
}

