/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.capabilities;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.Identifier;

public class CapabilityRegistry<C> {
    private final ConcurrentMap<Identifier, StoredCap<C>> caps = new ConcurrentHashMap<Identifier, StoredCap<C>>();
    private final CapabilityConstructor<C> constructor;

    public CapabilityRegistry(CapabilityConstructor<C> constructor) {
        Objects.requireNonNull(constructor);
        this.constructor = constructor;
    }

    public C create(Identifier name, Class<?> typeClass, Class<?> contextClass) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(typeClass);
        Objects.requireNonNull(contextClass);
        StoredCap ret = (StoredCap)this.caps.get(name);
        if (ret == null) {
            ret = this.caps.computeIfAbsent(name, n -> new StoredCap<C>(this.constructor.create((Identifier)n, typeClass, contextClass), typeClass, contextClass));
        }
        if (ret.typeClass != typeClass) {
            throw new IllegalStateException("Attempted to register capability " + String.valueOf(name) + " with existing type class " + String.valueOf(ret.typeClass) + " != " + String.valueOf(typeClass));
        }
        if (ret.contextClass != contextClass) {
            throw new IllegalStateException("Attempted to register capability " + String.valueOf(name) + " with existing context class " + String.valueOf(ret.contextClass) + " != " + String.valueOf(contextClass));
        }
        return ret.cap;
    }

    public List<C> getAll() {
        return this.caps.values().stream().map(StoredCap::cap).toList();
    }

    @FunctionalInterface
    public static interface CapabilityConstructor<C> {
        public C create(Identifier var1, Class<?> var2, Class<?> var3);
    }

    private record StoredCap<C>(C cap, Class<?> typeClass, Class<?> contextClass) {
    }
}

