/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.negotiation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.negotiation.NegotiableNetworkComponent;
import net.neoforged.neoforge.network.negotiation.NegotiatedNetworkComponent;
import net.neoforged.neoforge.network.negotiation.NegotiationResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public class NetworkComponentNegotiator {
    public static NegotiationResult negotiate(List<NegotiableNetworkComponent> server, List<NegotiableNetworkComponent> client) {
        server = new ArrayList<NegotiableNetworkComponent>(server);
        client = new ArrayList<NegotiableNetworkComponent>(client);
        List<NegotiableNetworkComponent> disabledOptionalOnClient = NetworkComponentNegotiator.buildDisabledOptionalComponents(client, server);
        client.removeAll(disabledOptionalOnClient);
        List<NegotiableNetworkComponent> finalClient = client;
        List<NegotiableNetworkComponent> disabledOptionalOnServer = NetworkComponentNegotiator.buildDisabledOptionalComponents(server, finalClient);
        server.removeAll(disabledOptionalOnServer);
        HashBasedTable matches = HashBasedTable.create();
        server.forEach(arg_0 -> NetworkComponentNegotiator.lambda$negotiate$0(finalClient, (Table)matches, arg_0));
        client.removeIf(arg_0 -> NetworkComponentNegotiator.lambda$negotiate$2((Table)matches, arg_0));
        server.removeIf(arg_0 -> NetworkComponentNegotiator.lambda$negotiate$3((Table)matches, arg_0));
        if (!client.isEmpty()) {
            HashMap<Identifier, Component> failureReasons = new HashMap<Identifier, Component>();
            client.forEach(c -> {
                MutableComponent channelFailureReason = Component.translatable((String)"neoforge.network.negotiation.failure.missing.client.server");
                String modDisplayName = ModList.get().getModContainerById(c.id().getNamespace()).map(mc -> mc.getModInfo().getDisplayName()).orElse("");
                failureReasons.put(c.id(), (Component)(modDisplayName.isEmpty() ? channelFailureReason : Component.translatable((String)"neoforge.network.negotiation.failure.mod", (Object[])new Object[]{modDisplayName, channelFailureReason})));
            });
            return new NegotiationResult(List.of(), false, failureReasons);
        }
        if (!server.isEmpty()) {
            HashMap<Identifier, Component> failureReasons = new HashMap<Identifier, Component>();
            server.forEach(c -> {
                MutableComponent channelFailureReason = Component.translatable((String)"neoforge.network.negotiation.failure.missing.server.client");
                String modDisplayName = ModList.get().getModContainerById(c.id().getNamespace()).map(mc -> mc.getModInfo().getDisplayName()).orElse("");
                failureReasons.put(c.id(), (Component)(modDisplayName.isEmpty() ? channelFailureReason : Component.translatable((String)"neoforge.network.negotiation.failure.mod", (Object[])new Object[]{modDisplayName, channelFailureReason})));
            });
            return new NegotiationResult(List.of(), false, failureReasons);
        }
        ArrayList<NegotiatedNetworkComponent> result = new ArrayList<NegotiatedNetworkComponent>();
        HashMap<Identifier, Component> failureReasons = new HashMap<Identifier, Component>();
        for (Table.Cell match : matches.cellSet()) {
            NegotiableNetworkComponent serverComponent = (NegotiableNetworkComponent)match.getColumnKey();
            NegotiableNetworkComponent clientComponent = (NegotiableNetworkComponent)match.getValue();
            String modDisplayName = ModList.get().getModContainerById(serverComponent.id().getNamespace()).map(mc -> mc.getModInfo().getDisplayName()).orElse("");
            Optional<ComponentNegotiationResult> serverToClientComparison = NetworkComponentNegotiator.validateComponent(serverComponent, clientComponent, "client");
            if (serverToClientComparison.isPresent() && !serverToClientComparison.get().success()) {
                failureReasons.put(serverComponent.id(), (Component)(modDisplayName.isEmpty() ? serverToClientComparison.get().failureReason() : Component.translatable((String)"neoforge.network.negotiation.failure.mod", (Object[])new Object[]{modDisplayName, serverToClientComparison.get().failureReason()})));
                continue;
            }
            Optional<ComponentNegotiationResult> clientToServerComparison = NetworkComponentNegotiator.validateComponent(clientComponent, serverComponent, "server");
            if (clientToServerComparison.isPresent() && !clientToServerComparison.get().success()) {
                failureReasons.put(serverComponent.id(), (Component)(modDisplayName.isEmpty() ? clientToServerComparison.get().failureReason() : Component.translatable((String)"neoforge.network.negotiation.failure.mod", (Object[])new Object[]{modDisplayName, clientToServerComparison.get().failureReason()})));
                continue;
            }
            result.add(new NegotiatedNetworkComponent(serverComponent.id(), serverComponent.version()));
        }
        if (failureReasons.isEmpty()) {
            return new NegotiationResult(result, true, failureReasons);
        }
        return new NegotiationResult(List.of(), false, failureReasons);
    }

    private static List<NegotiableNetworkComponent> buildDisabledOptionalComponents(List<NegotiableNetworkComponent> currentSide, List<NegotiableNetworkComponent> otherSide) {
        return currentSide.stream().filter(NegotiableNetworkComponent::optional).filter(c -> otherSide.stream().noneMatch(c2 -> c2.id().equals((Object)c.id()))).toList();
    }

    @VisibleForTesting
    public static Optional<ComponentNegotiationResult> validateComponent(NegotiableNetworkComponent left, NegotiableNetworkComponent right, String requestingSide) {
        if (left.flow().isPresent()) {
            if (right.flow().isEmpty()) {
                return Optional.of(new ComponentNegotiationResult(false, (Component)Component.translatable((String)"neoforge.network.negotiation.failure.flow.%s.missing".formatted(requestingSide), (Object[])new Object[]{left.flow().get().toString()})));
            }
            if (left.flow().get() != right.flow().get()) {
                return Optional.of(new ComponentNegotiationResult(false, (Component)Component.translatable((String)"neoforge.network.negotiation.failure.flow.%s.mismatch".formatted(requestingSide), (Object[])new Object[]{left.flow().get().toString(), right.flow().get().toString()})));
            }
        }
        if (!left.version().equals(right.version())) {
            return Optional.of(new ComponentNegotiationResult(false, (Component)Component.translatable((String)"neoforge.network.negotiation.failure.version.mismatch", (Object[])new Object[]{left.version(), right.version()})));
        }
        return Optional.empty();
    }

    private static /* synthetic */ boolean lambda$negotiate$3(Table matches, NegotiableNetworkComponent c) {
        return matches.containsRow((Object)c.id());
    }

    private static /* synthetic */ boolean lambda$negotiate$2(Table matches, NegotiableNetworkComponent c) {
        return matches.containsRow((Object)c.id());
    }

    private static /* synthetic */ void lambda$negotiate$0(List finalClient, Table matches, NegotiableNetworkComponent s) {
        finalClient.forEach(c -> {
            if (s.id().equals((Object)c.id())) {
                matches.put((Object)s.id(), (Object)s, c);
            }
        });
    }

    public record ComponentNegotiationResult(boolean success, @Nullable Component failureReason) {
    }
}

