/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableIdCondition
implements LootItemCondition {
    public static final MapCodec<LootTableIdCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Identifier.CODEC.fieldOf("loot_table_id").forGetter(idCondition -> idCondition.targetLootTableId)).apply((Applicative)builder, LootTableIdCondition::new));
    public static final Identifier UNKNOWN_LOOT_TABLE = Identifier.fromNamespaceAndPath((String)"neoforge", (String)"unknown_loot_table");
    private final Identifier targetLootTableId;

    private LootTableIdCondition(Identifier targetLootTableId) {
        this.targetLootTableId = targetLootTableId;
    }

    public MapCodec<? extends LootItemCondition> codec() {
        return CODEC;
    }

    public boolean test(LootContext lootContext) {
        return lootContext.getQueriedLootTableId().equals((Object)this.targetLootTableId);
    }

    public static Builder builder(Identifier targetLootTableId) {
        return new Builder(targetLootTableId);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Identifier targetLootTableId;

        public Builder(Identifier targetLootTableId) {
            if (targetLootTableId == null) {
                throw new IllegalArgumentException("Target loot table must not be null");
            }
            this.targetLootTableId = targetLootTableId;
        }

        public LootItemCondition build() {
            return new LootTableIdCondition(this.targetLootTableId);
        }
    }
}

