/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.ItemAbility;

public class CanItemPerformAbility
implements LootItemCondition {
    public static MapCodec<CanItemPerformAbility> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemAbility.CODEC.fieldOf("ability").forGetter(action -> action.ability)).apply((Applicative)builder, CanItemPerformAbility::new));
    final ItemAbility ability;

    public CanItemPerformAbility(ItemAbility ability) {
        this.ability = ability;
    }

    public MapCodec<? extends LootItemCondition> codec() {
        return CODEC;
    }

    public Set<ContextKey<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.TOOL);
    }

    public boolean test(LootContext lootContext) {
        ItemStack itemstack = (ItemStack)lootContext.getOptionalParameter(LootContextParams.TOOL);
        return itemstack != null && itemstack.canPerformAction(this.ability);
    }

    public static LootItemCondition.Builder canItemPerformAbility(ItemAbility action) {
        return () -> new CanItemPerformAbility(action);
    }
}

