/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.quad;

import com.mojang.math.Transformation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.neoforged.neoforge.client.model.quad.BakedNormals;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public final class QuadTransforms {
    private QuadTransforms() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BakedQuad applyTransformation(BakedQuad quad, Transformation transformation) {
        BakedNormals updatedNormals;
        if (transformation.isIdentity()) {
            return quad;
        }
        if (quad.bakedNormals() == BakedNormals.UNSPECIFIED) {
            updatedNormals = BakedNormals.UNSPECIFIED;
        } else {
            Vector3f normalTemp = new Vector3f();
            BakedNormals bakedNormals = quad.bakedNormals();
            Objects.requireNonNull(bakedNormals);
            BakedNormals bakedNormals2 = bakedNormals;
            int n = 0;
            updatedNormals = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BakedNormals.PerQuad.class, BakedNormals.PerVertex.class}, (BakedNormals)bakedNormals2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int var8_8;
                    BakedNormals.PerQuad var6_7 = (BakedNormals.PerQuad)bakedNormals2;
                    int var9_10 = var8_8 = var6_7.normal();
                    int n = var8_8;
                    yield BakedNormals.of(QuadTransforms.transformNormal(normalTemp, n, transformation));
                }
                case 1 -> {
                    int var13_13;
                    BakedNormals.PerVertex var8_9 = (BakedNormals.PerVertex)bakedNormals2;
                    int var14_14 = var13_13 = var8_9.normal0();
                    int n0 = var13_13;
                    var14_14 = var13_13 = var8_9.normal1();
                    int n1 = var13_13;
                    var14_14 = var13_13 = var8_9.normal2();
                    int n2 = var13_13;
                    var14_14 = var13_13 = var8_9.normal3();
                    int n3 = var13_13;
                    yield BakedNormals.of(QuadTransforms.transformNormal(normalTemp, n0, transformation), QuadTransforms.transformNormal(normalTemp, n1, transformation), QuadTransforms.transformNormal(normalTemp, n2, transformation), QuadTransforms.transformNormal(normalTemp, n3, transformation));
                }
            };
        }
        Vector4f posTemp = new Vector4f();
        return new BakedQuad(QuadTransforms.transformPosition(posTemp, quad.position0(), transformation), QuadTransforms.transformPosition(posTemp, quad.position1(), transformation), QuadTransforms.transformPosition(posTemp, quad.position2(), transformation), QuadTransforms.transformPosition(posTemp, quad.position3(), transformation), quad.packedUV0(), quad.packedUV1(), quad.packedUV2(), quad.packedUV3(), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission(), updatedNormals, quad.bakedColors(), quad.hasAmbientOcclusion());
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static Vector3fc transformPosition(Vector4f temp, Vector3fc pos, Transformation transformation) {
        temp.set(pos.x(), pos.y(), pos.z(), 1.0f);
        transformation.transformPosition(temp);
        temp.div(temp.w);
        return new Vector3f(temp.x(), temp.y(), temp.z());
    }

    private static int transformNormal(Vector3f temp, int packedNormal, Transformation transformation) {
        BakedNormals.unpack(packedNormal, temp);
        transformation.transformNormal(temp);
        return BakedNormals.pack((Vector3fc)temp);
    }
}

