/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.quad;

import java.util.Arrays;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.neoforged.neoforge.client.model.quad.BakedColors;
import net.neoforged.neoforge.client.model.quad.BakedNormals;
import net.neoforged.neoforge.client.model.quad.UVTransform;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class MutableQuad {
    private final Vector3f[] positions = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
    private final long[] uvs = new long[4];
    private final int[] normals = new int[4];
    private final int[] colors = new int[4];
    private int tintIndex = -1;
    private Direction direction = Direction.DOWN;
    private @Nullable TextureAtlasSprite sprite;
    private boolean shade = true;
    private int lightEmission;
    private boolean hasAmbientOcclusion;
    private @Nullable BakedQuad lastSourceQuad;

    public MutableQuad() {
        this.reset();
    }

    @Contract(pure=true)
    public float x(int vertexIndex) {
        return this.positions[vertexIndex].x;
    }

    @Contract(pure=true)
    public float y(int vertexIndex) {
        return this.positions[vertexIndex].y;
    }

    @Contract(pure=true)
    public float z(int vertexIndex) {
        return this.positions[vertexIndex].z;
    }

    @Contract(pure=true)
    public float positionComponent(int vertexIndex, int componentIndex) {
        return this.positions[vertexIndex].get(componentIndex);
    }

    @Contract(pure=true)
    public Vector3f copyPosition(int vertexIndex) {
        return new Vector3f((Vector3fc)this.positions[vertexIndex]);
    }

    public Vector3f copyPosition(int vertexIndex, Vector3f dest) {
        Vector3f pos = this.positions[vertexIndex];
        dest.set((Vector3fc)pos);
        return dest;
    }

    public MutableQuad setX(int vertexIndex, float x) {
        this.positions[vertexIndex].x = x;
        return this;
    }

    public MutableQuad setY(int vertexIndex, float y) {
        this.positions[vertexIndex].y = y;
        return this;
    }

    public MutableQuad setZ(int vertexIndex, float z) {
        this.positions[vertexIndex].z = z;
        return this;
    }

    public MutableQuad setPositionComponent(int vertexIndex, int componentIndex, float value) {
        this.positions[vertexIndex].setComponent(componentIndex, value);
        return this;
    }

    public MutableQuad setPosition(int vertexIndex, float x, float y, float z) {
        this.positions[vertexIndex].set(x, y, z);
        return this;
    }

    public MutableQuad setPosition(int vertexIndex, Vector3fc position) {
        this.positions[vertexIndex].set(position);
        return this;
    }

    public MutableQuad setCubeFaceFromSpriteCoords(Direction side, float left, float bottom, float right, float top, float depth) {
        this.direction = side;
        switch (side) {
            case NORTH: {
                this.positions[0].set(1.0f - left, top, depth);
                this.positions[1].set(1.0f - left, bottom, depth);
                this.positions[2].set(1.0f - right, bottom, depth);
                this.positions[3].set(1.0f - right, top, depth);
                break;
            }
            case SOUTH: {
                this.positions[0].set(left, top, 1.0f - depth);
                this.positions[1].set(left, bottom, 1.0f - depth);
                this.positions[2].set(right, bottom, 1.0f - depth);
                this.positions[3].set(right, top, 1.0f - depth);
                break;
            }
            case EAST: {
                this.positions[0].set(1.0f - depth, top, 1.0f - left);
                this.positions[1].set(1.0f - depth, bottom, 1.0f - left);
                this.positions[2].set(1.0f - depth, bottom, 1.0f - right);
                this.positions[3].set(1.0f - depth, top, 1.0f - right);
                break;
            }
            case WEST: {
                this.positions[0].set(depth, top, left);
                this.positions[1].set(depth, bottom, left);
                this.positions[2].set(depth, bottom, right);
                this.positions[3].set(depth, top, right);
                break;
            }
            case UP: {
                this.positions[0].set(left, 1.0f - depth, 1.0f - top);
                this.positions[1].set(left, 1.0f - depth, 1.0f - bottom);
                this.positions[2].set(right, 1.0f - depth, 1.0f - bottom);
                this.positions[3].set(right, 1.0f - depth, 1.0f - top);
                break;
            }
            case DOWN: {
                this.positions[0].set(left, depth, top);
                this.positions[1].set(left, depth, bottom);
                this.positions[2].set(right, depth, bottom);
                this.positions[3].set(right, depth, top);
            }
        }
        return this;
    }

    public MutableQuad setFullCubeFace(Direction side) {
        return this.setCubeFace(side, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public MutableQuad setCubeFace(Direction side, Vector3fc from, Vector3fc to) {
        return this.setCubeFace(side, from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
    }

    public MutableQuad setCubeFace(Direction side, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        this.direction = side;
        for (int i = 0; i < 4; ++i) {
            FaceInfo.VertexInfo vertexInfo = FaceInfo.fromFacing((Direction)side).getVertexInfo(i);
            this.positions[i].set(vertexInfo.xFace().select(fromX, fromY, fromZ, toX, toY, toZ), vertexInfo.yFace().select(fromX, fromY, fromZ, toX, toY, toZ), vertexInfo.zFace().select(fromX, fromY, fromZ, toX, toY, toZ));
        }
        return this;
    }

    @Contract(pure=true)
    public float u(int vertexIndex) {
        return UVPair.unpackU((long)this.uvs[vertexIndex]);
    }

    @Contract(pure=true)
    public float v(int vertexIndex) {
        return UVPair.unpackV((long)this.uvs[vertexIndex]);
    }

    @Contract(pure=true)
    public long packedUv(int vertexIndex) {
        return this.uvs[vertexIndex];
    }

    @Contract(pure=true)
    public Vector2f copyUv(int vertexIndex) {
        return this.copyUv(vertexIndex, new Vector2f());
    }

    public Vector2f copyUv(int vertexIndex, Vector2f dest) {
        long packedUv = this.uvs[vertexIndex];
        dest.x = UVPair.unpackU((long)packedUv);
        dest.y = UVPair.unpackV((long)packedUv);
        return dest;
    }

    public MutableQuad setUv(int vertexIndex, float u, float v) {
        this.uvs[vertexIndex] = UVPair.pack((float)u, (float)v);
        return this;
    }

    public MutableQuad setUv(int vertexIndex, Vector2fc uv) {
        return this.setUv(vertexIndex, uv.x(), uv.y());
    }

    public MutableQuad setPackedUv(int vertexIndex, long packedUv) {
        this.uvs[vertexIndex] = packedUv;
        return this;
    }

    public MutableQuad setUvFromSprite(int vertexIndex, float u, float v) {
        TextureAtlasSprite sprite = this.requiredSprite();
        return this.setUv(vertexIndex, sprite.getU(u), sprite.getV(v));
    }

    public MutableQuad setUvFromSprite(int vertexIndex, Vector2fc uv) {
        return this.setUvFromSprite(vertexIndex, uv.x(), uv.y());
    }

    public MutableQuad bakeUvsFromPosition() {
        return this.bakeUvsFromPosition(UVTransform.IDENTITY);
    }

    public MutableQuad bakeUvsFromPosition(UVTransform transform) {
        int i;
        switch (this.direction) {
            case DOWN: {
                for (i = 0; i < 4; ++i) {
                    this.uvs[i] = UVPair.pack((float)this.positions[i].x, (float)(1.0f - this.positions[i].z));
                }
                break;
            }
            case UP: {
                for (i = 0; i < 4; ++i) {
                    this.uvs[i] = UVPair.pack((float)this.positions[i].x, (float)this.positions[i].z);
                }
                break;
            }
            case NORTH: {
                for (i = 0; i < 4; ++i) {
                    this.uvs[i] = UVPair.pack((float)(1.0f - this.positions[i].x), (float)(1.0f - this.positions[i].y));
                }
                break;
            }
            case SOUTH: {
                for (i = 0; i < 4; ++i) {
                    this.uvs[i] = UVPair.pack((float)this.positions[i].x, (float)(1.0f - this.positions[i].y));
                }
                break;
            }
            case WEST: {
                for (i = 0; i < 4; ++i) {
                    this.uvs[i] = UVPair.pack((float)this.positions[i].z, (float)(1.0f - this.positions[i].y));
                }
                break;
            }
            case EAST: {
                for (i = 0; i < 4; ++i) {
                    this.uvs[i] = UVPair.pack((float)(1.0f - this.positions[i].z), (float)(1.0f - this.positions[i].y));
                }
                break;
            }
        }
        if (!transform.isIdentity()) {
            for (i = 0; i < 4; ++i) {
                this.uvs[i] = transform.transformPacked(this.uvs[i]);
            }
        }
        this.transformUvsFromSpriteToAtlas();
        return this;
    }

    @Contract(pure=true)
    public int tintIndex() {
        return this.tintIndex;
    }

    public MutableQuad setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
        return this;
    }

    @Contract(pure=true)
    public Direction direction() {
        return this.direction;
    }

    public MutableQuad setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    @Contract(pure=true)
    public @Nullable TextureAtlasSprite sprite() {
        return this.sprite;
    }

    @Contract(pure=true)
    public TextureAtlasSprite requiredSprite() {
        if (this.sprite == null) {
            throw new IllegalStateException("A sprite has to be set on this quad before UVs are manipulated");
        }
        return this.sprite;
    }

    public MutableQuad setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    public MutableQuad setSpriteAndMoveUv(TextureAtlasSprite sprite) {
        this.transformUvsFromAtlasToSprite();
        this.sprite = sprite;
        this.transformUvsFromSpriteToAtlas();
        return this;
    }

    @Contract(pure=true)
    public boolean shade() {
        return this.shade;
    }

    public MutableQuad setShade(boolean shade) {
        this.shade = shade;
        return this;
    }

    @Contract(pure=true)
    public int lightEmission() {
        return this.lightEmission;
    }

    public MutableQuad setLightEmission(int lightEmission) {
        this.lightEmission = lightEmission;
        return this;
    }

    @Contract(pure=true)
    public float normalX(int vertexIndex) {
        return this.normalComponent(vertexIndex, 0);
    }

    @Contract(pure=true)
    public float normalY(int vertexIndex) {
        return this.normalComponent(vertexIndex, 1);
    }

    @Contract(pure=true)
    public float normalZ(int vertexIndex) {
        return this.normalComponent(vertexIndex, 2);
    }

    @Contract(pure=true)
    public float normalComponent(int vertexIndex, int componentIndex) {
        int packedNormal = this.normals[vertexIndex];
        if (BakedNormals.isUnspecified(packedNormal)) {
            return Float.NaN;
        }
        return BakedNormals.unpackComponent(packedNormal, componentIndex);
    }

    @Contract(pure=true)
    public int packedNormal(int vertexIndex) {
        return this.normals[vertexIndex];
    }

    @Contract(pure=true)
    public Vector3f copyNormal(int vertexIndex) {
        return this.copyNormal(vertexIndex, new Vector3f());
    }

    public Vector3f copyNormal(int vertexIndex, Vector3f dest) {
        return BakedNormals.unpack(this.normals[vertexIndex], dest);
    }

    public MutableQuad setNormal(int vertexIndex, float x, float y, float z) {
        this.normals[vertexIndex] = BakedNormals.pack(x, y, z);
        return this;
    }

    public MutableQuad setNormal(int vertexIndex, Vector3fc normal) {
        this.normals[vertexIndex] = BakedNormals.pack(normal);
        return this;
    }

    public MutableQuad setNormalComponent(int vertexIndex, int componentIndex, float value) {
        float z;
        float y;
        int normal = this.normals[vertexIndex];
        if (BakedNormals.isUnspecified(normal)) {
            x = 0.0f;
            y = 0.0f;
            z = 0.0f;
        } else {
            x = BakedNormals.unpackX(normal);
            y = BakedNormals.unpackY(normal);
            z = BakedNormals.unpackZ(normal);
        }
        float x = switch (componentIndex) {
            case 0 -> value;
            case 1 -> {
                y = value;
            }
            case 2 -> {
                z = value;
            }
            default -> throw new IllegalArgumentException();
        };
        this.normals[vertexIndex] = BakedNormals.pack(x, y, z);
        return this;
    }

    public MutableQuad setPackedNormal(int vertexIndex, int packedNormal) {
        this.normals[vertexIndex] = packedNormal;
        return this;
    }

    public MutableQuad setNormal(BakedNormals bakedNormals) {
        this.normals[0] = bakedNormals.normal(0);
        this.normals[1] = bakedNormals.normal(1);
        this.normals[2] = bakedNormals.normal(2);
        this.normals[3] = bakedNormals.normal(3);
        return this;
    }

    @Contract(pure=true)
    public int color(int vertexIndex) {
        return this.colors[vertexIndex];
    }

    public MutableQuad setColor(int packedColor) {
        this.colors[0] = packedColor;
        this.colors[1] = packedColor;
        this.colors[2] = packedColor;
        this.colors[3] = packedColor;
        return this;
    }

    public MutableQuad setColor(int vertexIndex, int packedColor) {
        this.colors[vertexIndex] = packedColor;
        return this;
    }

    public MutableQuad setColor(int vertexIndex, int r, int g, int b, int a) {
        return this.setColor(vertexIndex, ARGB.color((int)a, (int)r, (int)g, (int)b));
    }

    public MutableQuad setColor(BakedColors bakedColors) {
        this.colors[0] = bakedColors.color(0);
        this.colors[1] = bakedColors.color(1);
        this.colors[2] = bakedColors.color(2);
        this.colors[3] = bakedColors.color(3);
        return this;
    }

    @Contract(pure=true)
    public boolean hasAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    public MutableQuad setHasAmbientOcclusion(boolean hasAmbientOcclusion) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        return this;
    }

    public MutableQuad setFrom(BakedQuad quad) {
        this.lastSourceQuad = quad;
        for (int i = 0; i < 4; ++i) {
            this.positions[i].set(quad.position(i));
            this.normals[i] = quad.bakedNormals().normal(i);
            this.colors[i] = quad.bakedColors().color(i);
            this.uvs[i] = quad.packedUV(i);
        }
        this.tintIndex = quad.tintIndex();
        this.direction = quad.direction();
        this.sprite = quad.sprite();
        this.shade = quad.shade();
        this.lightEmission = quad.lightEmission();
        this.hasAmbientOcclusion = quad.hasAmbientOcclusion();
        return this;
    }

    private void transformUvsFromSpriteToAtlas() {
        TextureAtlasSprite sprite = this.requiredSprite();
        for (int i = 0; i < 4; ++i) {
            long packedUv = this.packedUv(i);
            this.setUv(i, sprite.getU(UVPair.unpackU((long)packedUv)), sprite.getV(UVPair.unpackV((long)packedUv)));
        }
    }

    private void transformUvsFromAtlasToSprite() {
        TextureAtlasSprite sprite = this.requiredSprite();
        float uOrigin = sprite.getU0();
        float vOrigin = sprite.getV0();
        float uWidth = sprite.getU1() - uOrigin;
        float vWidth = sprite.getV1() - vOrigin;
        for (int i = 0; i < 4; ++i) {
            long packedUv = this.packedUv(i);
            float u = (UVPair.unpackU((long)packedUv) - uOrigin) / uWidth;
            float v = (UVPair.unpackV((long)packedUv) - vOrigin) / vWidth;
            this.setUv(i, u, v);
        }
    }

    @Contract(pure=true)
    public BakedQuad toBakedQuad() {
        BakedColors bakedColors;
        BakedNormals bakedNormals;
        Vector3fc pos3;
        Vector3fc pos2;
        Vector3fc pos1;
        Vector3fc pos0;
        if (this.lastSourceQuad != null) {
            int i;
            pos0 = MutableQuad.reuseVector(this.lastSourceQuad, this.positions[0]);
            pos1 = MutableQuad.reuseVector(this.lastSourceQuad, this.positions[1]);
            pos2 = MutableQuad.reuseVector(this.lastSourceQuad, this.positions[2]);
            pos3 = MutableQuad.reuseVector(this.lastSourceQuad, this.positions[3]);
            bakedNormals = this.lastSourceQuad.bakedNormals();
            for (i = 0; i < 4; ++i) {
                if (bakedNormals.normal(i) == this.normals[i]) continue;
                bakedNormals = BakedNormals.of(this.normals[0], this.normals[1], this.normals[2], this.normals[3]);
                break;
            }
            bakedColors = this.lastSourceQuad.bakedColors();
            for (i = 0; i < 4; ++i) {
                if (bakedColors.color(i) == this.colors[i]) continue;
                bakedColors = BakedColors.of(this.colors[0], this.colors[1], this.colors[2], this.colors[3]);
                break;
            }
        } else {
            pos0 = new Vector3f((Vector3fc)this.positions[0]);
            pos1 = new Vector3f((Vector3fc)this.positions[1]);
            pos2 = new Vector3f((Vector3fc)this.positions[2]);
            pos3 = new Vector3f((Vector3fc)this.positions[3]);
            bakedNormals = BakedNormals.of(this.normals[0], this.normals[1], this.normals[2], this.normals[3]);
            bakedColors = BakedColors.of(this.colors[0], this.colors[1], this.colors[2], this.colors[3]);
        }
        TextureAtlasSprite sprite = this.requiredSprite();
        return new BakedQuad(pos0, pos1, pos2, pos3, this.uvs[0], this.uvs[1], this.uvs[2], this.uvs[3], this.tintIndex, this.direction, sprite, this.shade, this.lightEmission, bakedNormals, bakedColors, this.hasAmbientOcclusion);
    }

    private static Vector3fc reuseVector(BakedQuad quad, Vector3f position) {
        for (int i = 0; i < 4; ++i) {
            if (!quad.position(i).equals((Object)position)) continue;
            return quad.position(i);
        }
        return new Vector3f((Vector3fc)position);
    }

    public MutableQuad transform(Matrix4f rotation) {
        Vector3f tmp = null;
        for (int i = 0; i < 4; ++i) {
            rotation.transformPosition(this.positions[i]);
            int normal = this.normals[i];
            if (BakedNormals.isUnspecified(normal)) continue;
            tmp = BakedNormals.unpack(normal, tmp);
            rotation.transformDirection(tmp);
            this.normals[i] = BakedNormals.pack((Vector3fc)tmp);
        }
        return this;
    }

    public MutableQuad recalculateWinding() {
        FaceBakery.recalculateWinding((Vector3fc[])this.positions, (long[])this.uvs, (Direction)this.direction, (int[])this.colors, (int[])this.normals);
        return this;
    }

    public MutableQuad reset() {
        for (int i = 0; i < 4; ++i) {
            this.positions[i].set(0.0f, 0.0f, 0.0f);
        }
        Arrays.fill(this.uvs, 0L);
        Arrays.fill(this.normals, 0);
        Arrays.fill(this.colors, -1);
        this.direction = Direction.DOWN;
        this.sprite = null;
        this.tintIndex = -1;
        this.shade = true;
        this.lightEmission = 0;
        this.hasAmbientOcclusion = false;
        this.lastSourceQuad = null;
        return this;
    }
}

