/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.quad;

import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public sealed interface BakedNormals {
    public static final BakedNormals UNSPECIFIED = new PerQuad(0);

    public int normal(int var1);

    public static BakedNormals of(int normal0, int normal1, int normal2, int normal3) {
        if (normal0 == normal1 && normal0 == normal2 && normal0 == normal3) {
            return BakedNormals.of(normal0);
        }
        return new PerVertex(normal0, normal1, normal2, normal3);
    }

    public static BakedNormals of(int normal) {
        return BakedNormals.isUnspecified(normal) ? UNSPECIFIED : new PerQuad(normal);
    }

    public static int pack(float x, float y, float z) {
        int packedx = (byte)Math.round(x * 127.0f) & 0xFF;
        int packedy = (byte)Math.round(y * 127.0f) & 0xFF;
        int packedz = (byte)Math.round(z * 127.0f) & 0xFF;
        return packedx | packedy << 8 | packedz << 16;
    }

    public static int pack(Vector3fc normal) {
        return BakedNormals.pack(normal.x(), normal.y(), normal.z());
    }

    public static float unpackComponent(int packedNormal, int axis) {
        int encodedNormalComponent = packedNormal >> axis * 8 & 0xFF;
        return (float)((byte)encodedNormalComponent) / 127.0f;
    }

    public static float unpackX(int packedNormal) {
        return (float)((byte)(packedNormal & 0xFF)) / 127.0f;
    }

    public static float unpackY(int packedNormal) {
        return (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f;
    }

    public static float unpackZ(int packedNormal) {
        return (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f;
    }

    public static Vector3f unpack(int packedNormal, @Nullable Vector3f destination) {
        if (destination == null) {
            destination = new Vector3f();
        }
        return destination.set(BakedNormals.unpackX(packedNormal), BakedNormals.unpackY(packedNormal), BakedNormals.unpackZ(packedNormal));
    }

    public static boolean isUnspecified(int packedNormal) {
        return (packedNormal & 0xFFFFFF) == 0;
    }

    public static int computeQuadNormal(Vector3fc position0, Vector3fc position1, Vector3fc position2, Vector3fc position3) {
        float nz;
        float ny;
        float dz1;
        float dx0 = position3.x() - position1.x();
        float dy0 = position3.y() - position1.y();
        float dz0 = position3.z() - position1.z();
        float dx1 = position2.x() - position0.x();
        float dy1 = position2.y() - position0.y();
        float nx = dy1 * dz0 - (dz1 = position2.z() - position0.z()) * dy0;
        float length = Mth.sqrt((float)(nx * nx + (ny = dz1 * dx0 - dx1 * dz0) * ny + (nz = dx1 * dy0 - dy1 * dx0) * nz));
        if (length > 0.0f) {
            nx /= length;
            ny /= length;
            nz /= length;
        }
        return BakedNormals.pack(nx, ny, nz);
    }

    public record PerVertex(int normal0, int normal1, int normal2, int normal3) implements BakedNormals
    {
        @Override
        public int normal(int vertex) {
            return switch (vertex) {
                case 0 -> this.normal0;
                case 1 -> this.normal1;
                case 2 -> this.normal2;
                case 3 -> this.normal3;
                default -> throw new IndexOutOfBoundsException(vertex);
            };
        }
    }

    public record PerQuad(int normal) implements BakedNormals
    {
        @Override
        public int normal(int vertex) {
            return this.normal;
        }
    }
}

