/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.extensions.common;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager;
import org.joml.Vector3d;
import org.jspecify.annotations.Nullable;

public interface IClientBlockExtensions {
    public static final IClientBlockExtensions DEFAULT = new IClientBlockExtensions(){};

    public static IClientBlockExtensions of(BlockState state) {
        return IClientBlockExtensions.of(state.getBlock());
    }

    public static IClientBlockExtensions of(Block block) {
        return ClientExtensionsManager.BLOCK_EXTENSIONS.getOrDefault(block, DEFAULT);
    }

    default public boolean addHitEffects(BlockState state, Level level, @Nullable HitResult target, ParticleEngine manager) {
        return !state.shouldSpawnTerrainParticles();
    }

    default public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
        return !state.shouldSpawnTerrainParticles();
    }

    default public boolean playHitSound(BlockState state, Level level, BlockPos pos, Direction face, SoundManager soundManager) {
        return false;
    }

    default public boolean playBreakSound(BlockState state, Level level, BlockPos pos) {
        return false;
    }

    default public Vector3d getFogColor(BlockState state, LevelReader level, BlockPos pos, Entity entity, Vector3d originalColor, float partialTick) {
        FluidState fluidState = level.getFluidState(pos);
        if (fluidState.is(FluidTags.WATER)) {
            float f12 = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity ent = (LivingEntity)entity;
                AttributeInstance attributeinstance = ent.getAttribute(Attributes.OXYGEN_BONUS);
                f12 = (float)(attributeinstance != null ? attributeinstance.getValue() : 0.0) * 0.2f;
                if (ent.hasEffect(MobEffects.WATER_BREATHING)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            return new Vector3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
        }
        if (fluidState.is(FluidTags.LAVA)) {
            return new Vector3d((double)0.6f, (double)0.1f, 0.0);
        }
        return originalColor;
    }

    default public boolean areBreakingParticlesTinted(BlockState state, ClientLevel level, BlockPos pos) {
        return !state.is((Object)Blocks.GRASS_BLOCK);
    }
}

