/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.extensions;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.util.ARGB;
import net.minecraft.util.LightCoordsUtil;
import net.neoforged.neoforge.client.model.quad.BakedNormals;
import net.neoforged.neoforge.client.model.quad.MutableQuad;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public interface IVertexConsumerExtension {
    private VertexConsumer self() {
        return (VertexConsumer)this;
    }

    default public VertexConsumer misc(VertexFormatElement element, int ... rawData) {
        return this.self();
    }

    default public void putBulkData(PoseStack.Pose pose, MutableQuad quad, float r, float g, float b, float a, int lightCoords, int overlayCoords) {
        this.putBulkData(pose, quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, r, g, b, a, new int[]{lightCoords, lightCoords, lightCoords, lightCoords}, overlayCoords);
    }

    default public void putBulkData(PoseStack.Pose pose, MutableQuad quad, float[] brightness, float r, float g, float b, float a, int[] lightmapCoord, int overlayCoords) {
        Matrix4f matrix = pose.pose();
        Vector3f faceNormal = pose.transformNormal(quad.direction().getUnitVec3f(), new Vector3f());
        int lightEmission = quad.lightEmission();
        for (int vertex = 0; vertex < 4; ++vertex) {
            long packedUv = quad.packedUv(vertex);
            float brightnessForVertex = brightness[vertex];
            int color = ARGB.colorFromFloat((float)a, (float)(brightnessForVertex * r), (float)(brightnessForVertex * g), (float)(brightnessForVertex * b));
            color = ARGB.multiply((int)color, (int)quad.color(vertex));
            int light = LightCoordsUtil.lightCoordsWithEmission((int)lightmapCoord[vertex], (int)lightEmission);
            Vector3f pos = matrix.transformPosition(quad.x(vertex), quad.y(vertex), quad.z(vertex), new Vector3f());
            float u = UVPair.unpackU((long)packedUv);
            float v = UVPair.unpackV((long)packedUv);
            int packedNormal = quad.packedNormal(vertex);
            Vector3f normal = !BakedNormals.isUnspecified(packedNormal) ? BakedNormals.unpack(packedNormal, new Vector3f()).mul((Matrix3fc)pose.normal()) : faceNormal;
            this.self().addVertex(pos.x(), pos.y(), pos.z(), color, u, v, overlayCoords, light, normal.x(), normal.y(), normal.z());
        }
    }

    default public void applyBakedNormals(Vector3f generated, BakedNormals data, int vertex, Matrix3f normalTransform) {
        int packed = data.normal(vertex);
        if (!BakedNormals.isUnspecified(packed)) {
            BakedNormals.unpack(packed, generated);
            generated.mul((Matrix3fc)normalTransform);
        }
    }
}

