/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import com.google.common.base.Predicates;
import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jspecify.annotations.Nullable;

public final class AttachmentType<T> {
    final Function<IAttachmentHolder, T> defaultValueSupplier;
    final @Nullable IAttachmentSerializer<T> serializer;
    final boolean copyOnDeath;
    final IAttachmentCopyHandler<T> copyHandler;
    @Nullable AttachmentSyncHandler<T> syncHandler;

    private AttachmentType(Builder<T> builder) {
        this.defaultValueSupplier = builder.defaultValueSupplier;
        this.serializer = builder.serializer;
        this.copyOnDeath = builder.copyOnDeath;
        this.copyHandler = builder.copyHandler != null ? builder.copyHandler : AttachmentType.defaultCopyHandler(this.serializer);
        this.syncHandler = builder.syncHandler;
    }

    private static <T> IAttachmentCopyHandler<T> defaultCopyHandler(@Nullable IAttachmentSerializer<T> serializer) {
        if (serializer == null) {
            return (attachment, holder, provider) -> {
                throw new UnsupportedOperationException("Cannot copy non-serializable attachments");
            };
        }
        return (attachment, holder, provider) -> {
            ProblemReporter.Collector reporter = new ProblemReporter.Collector();
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)provider);
            if (!serializer.write(attachment, (ValueOutput)output)) {
                return null;
            }
            if (!reporter.isEmpty()) {
                throw new IllegalArgumentException("Attachment failed to serialise during copy: " + reporter.getReport());
            }
            reporter = new ProblemReporter.Collector();
            ValueInput input = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)provider, (CompoundTag)output.buildResult());
            Object attach = serializer.read(holder, input);
            if (!reporter.isEmpty()) {
                throw new IllegalArgumentException("Attachment failed to deserialise during copy: " + reporter.getReport());
            }
            return attach;
        };
    }

    public static <T> Builder<T> builder(Supplier<T> defaultValueSupplier) {
        return AttachmentType.builder((IAttachmentHolder holder) -> defaultValueSupplier.get());
    }

    public static <T> Builder<T> builder(Function<IAttachmentHolder, T> defaultValueConstructor) {
        return new Builder<T>(defaultValueConstructor);
    }

    public static <T extends ValueIOSerializable> Builder<T> serializable(Supplier<T> defaultValueSupplier) {
        return AttachmentType.serializable((IAttachmentHolder holder) -> (ValueIOSerializable)defaultValueSupplier.get());
    }

    public static <T extends ValueIOSerializable> Builder<T> serializable(final Function<IAttachmentHolder, T> defaultValueConstructor) {
        return AttachmentType.builder(defaultValueConstructor).serialize(new IAttachmentSerializer<T>(){

            @Override
            public T read(IAttachmentHolder holder, ValueInput input) {
                ValueIOSerializable ret = (ValueIOSerializable)defaultValueConstructor.apply(holder);
                ret.deserialize(input);
                return ret;
            }

            @Override
            public boolean write(T attachment, ValueOutput output) {
                attachment.serialize(output);
                return true;
            }
        });
    }

    public static class Builder<T> {
        private final Function<IAttachmentHolder, T> defaultValueSupplier;
        private @Nullable IAttachmentSerializer<T> serializer;
        private boolean copyOnDeath;
        private @Nullable IAttachmentCopyHandler<T> copyHandler;
        private @Nullable AttachmentSyncHandler<T> syncHandler;

        private Builder(Function<IAttachmentHolder, T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
        }

        public Builder<T> serialize(IAttachmentSerializer<T> serializer) {
            Objects.requireNonNull(serializer);
            if (this.serializer != null) {
                throw new IllegalStateException("Serializer already set");
            }
            this.serializer = serializer;
            return this;
        }

        public Builder<T> serialize(MapCodec<T> codec) {
            return this.serialize(codec, (Predicate<? super T>)Predicates.alwaysTrue());
        }

        public Builder<T> serialize(final MapCodec<T> codec, final Predicate<? super T> shouldSerialize) {
            Objects.requireNonNull(codec);
            return this.serialize(new IAttachmentSerializer<T>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public T read(IAttachmentHolder holder, ValueInput input) {
                    Optional parsingResult = input.read(codec);
                    return parsingResult.orElseThrow(() -> this.buildException("read"));
                }

                @Override
                public boolean write(T attachment, ValueOutput output) {
                    if (!shouldSerialize.test(attachment)) {
                        return false;
                    }
                    output.store(codec, attachment);
                    return true;
                }

                private RuntimeException buildException(String operation) {
                    return new IllegalStateException("Unable to " + operation + " attachment due to an internal codec error.");
                }
            });
        }

        public Builder<T> copyOnDeath() {
            if (this.serializer == null) {
                throw new IllegalStateException("copyOnDeath requires a serializer");
            }
            this.copyOnDeath = true;
            return this;
        }

        public Builder<T> copyHandler(IAttachmentCopyHandler<T> cloner) {
            Objects.requireNonNull(cloner);
            if (this.serializer == null) {
                throw new IllegalStateException("copyHandler requires a serializer");
            }
            this.copyHandler = cloner;
            return this;
        }

        public Builder<T> sync(AttachmentSyncHandler<T> syncHandler) {
            Objects.requireNonNull(syncHandler);
            this.syncHandler = syncHandler;
            return this;
        }

        public Builder<T> sync(StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
            return this.sync((holder, to) -> true, streamCodec);
        }

        public Builder<T> sync(final BiPredicate<IAttachmentHolder, ServerPlayer> sendToPlayer, final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
            Objects.requireNonNull(sendToPlayer);
            Objects.requireNonNull(streamCodec);
            return this.sync(new AttachmentSyncHandler<T>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean sendToPlayer(IAttachmentHolder holder, ServerPlayer to) {
                    return sendToPlayer.test(holder, to);
                }

                @Override
                public void write(RegistryFriendlyByteBuf buf, T attachment, boolean initialSync) {
                    streamCodec.encode((Object)buf, attachment);
                }

                @Override
                public T read(IAttachmentHolder holder, RegistryFriendlyByteBuf buf, @Nullable T previousValue) {
                    return streamCodec.decode((Object)buf);
                }
            });
        }

        public AttachmentType<T> build() {
            return new AttachmentType(this);
        }
    }
}

