/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.crafting.display.ForFluidStacks;

public record FluidTagSlotDisplay(TagKey<Fluid> tag) implements SlotDisplay
{
    public static final MapCodec<FluidTagSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(FluidTagSlotDisplay::tag)).apply((Applicative)i, FluidTagSlotDisplay::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidTagSlotDisplay> STREAM_CODEC = StreamCodec.composite((StreamCodec)TagKey.streamCodec((ResourceKey)Registries.FLUID), FluidTagSlotDisplay::tag, FluidTagSlotDisplay::new);

    public SlotDisplay.Type<FluidTagSlotDisplay> type() {
        return NeoForgeMod.FLUID_TAG_SLOT_DISPLAY.get();
    }

    public <T> Stream<T> resolve(ContextMap context, DisplayContentsFactory<T> factory) {
        if (factory instanceof ForFluidStacks) {
            ForFluidStacks fluids = (ForFluidStacks)factory;
            HolderLookup.Provider registries = (HolderLookup.Provider)context.getOptional(SlotDisplayContext.REGISTRIES);
            if (registries != null) {
                return registries.lookupOrThrow(Registries.FLUID).get(this.tag).map(t -> t.stream().map(fluids::forStack)).stream().flatMap(s -> s);
            }
        }
        return Stream.empty();
    }
}

