/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class IngredientCodecs {
    private static final int CUSTOM_INGREDIENT_MARKER = -1000;
    private static final StreamCodec<RegistryFriendlyByteBuf, ICustomIngredient> CUSTOM_INGREDIENT_CODEC = ByteBufCodecs.registry(NeoForgeRegistries.Keys.INGREDIENT_TYPES).dispatch(ICustomIngredient::getType, IngredientType::streamCodec);

    public static Codec<Ingredient> codec(Codec<Ingredient> vanillaCodec) {
        Codec customIngredientCodec = NeoForgeRegistries.INGREDIENT_TYPES.byNameCodec().dispatch("neoforge:ingredient_type", ICustomIngredient::getType, IngredientType::codec);
        return Codec.xor((Codec)customIngredientCodec, vanillaCodec).xmap(either -> (Ingredient)either.map(ICustomIngredient::toVanilla, i -> i), ingredient -> {
            if (ingredient.isCustom()) {
                return Either.left((Object)ingredient.getCustomIngredient());
            }
            return Either.right((Object)ingredient);
        });
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Ingredient> streamCodec(final StreamCodec<RegistryFriendlyByteBuf, Ingredient> vanillaCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Ingredient>(){

            public Ingredient decode(RegistryFriendlyByteBuf buf) {
                int readerIndex = buf.readerIndex();
                int length = buf.readVarInt();
                if (length == -1000) {
                    return ((ICustomIngredient)CUSTOM_INGREDIENT_CODEC.decode((Object)buf)).toVanilla();
                }
                buf.readerIndex(readerIndex);
                return (Ingredient)vanillaCodec.decode((Object)buf);
            }

            public void encode(RegistryFriendlyByteBuf buf, Ingredient ingredient) {
                if (ingredient.isCustom() && buf.getConnectionType().isNeoForge()) {
                    buf.writeVarInt(-1000);
                    CUSTOM_INGREDIENT_CODEC.encode((Object)buf, (Object)ingredient.getCustomIngredient());
                } else {
                    vanillaCodec.encode((Object)buf, (Object)ingredient);
                }
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> optionalStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> vanillaCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>>(){

            public Optional<Ingredient> decode(RegistryFriendlyByteBuf buf) {
                int readerIndex = buf.readerIndex();
                int length = buf.readVarInt();
                if (length == -1000) {
                    return Optional.of(((ICustomIngredient)CUSTOM_INGREDIENT_CODEC.decode((Object)buf)).toVanilla());
                }
                buf.readerIndex(readerIndex);
                return (Optional)vanillaCodec.decode((Object)buf);
            }

            public void encode(RegistryFriendlyByteBuf buf, Optional<Ingredient> ingredient) {
                if (ingredient.isPresent() && ingredient.get().isCustom() && buf.getConnectionType().isNeoForge()) {
                    buf.writeVarInt(-1000);
                    CUSTOM_INGREDIENT_CODEC.encode((Object)buf, (Object)ingredient.get().getCustomIngredient());
                } else {
                    vanillaCodec.encode((Object)buf, ingredient);
                }
            }
        };
    }
}

