/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.fml.Logging;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class ModConfigSpec
implements IConfigSpec {
    private final Map<List<String>, String> levelComments;
    private final Map<List<String>, String> levelTranslationKeys;
    private final UnmodifiableConfig spec;
    private final UnmodifiableConfig values;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IConfigSpec.ILoadedConfig loadedConfig;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private ModConfigSpec(UnmodifiableConfig spec, UnmodifiableConfig values, Map<List<String>, String> levelComments, Map<List<String>, String> levelTranslationKeys) {
        this.spec = spec;
        this.values = values;
        this.levelComments = levelComments;
        this.levelTranslationKeys = levelTranslationKeys;
    }

    public boolean isEmpty() {
        return this.spec.isEmpty();
    }

    public String getLevelComment(List<String> path) {
        return this.levelComments.get(path);
    }

    public String getLevelTranslationKey(List<String> path) {
        return this.levelTranslationKeys.get(path);
    }

    public void acceptConfig(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IConfigSpec.ILoadedConfig config) {
        this.loadedConfig = config;
        if (config != null && !this.isCorrect((UnmodifiableCommentedConfig)config.config())) {
            LOGGER.warn(Logging.CORE, "Configuration {} is not correct. Correcting", (Object)config);
            this.correct(config.config(), (action, path, incorrectValue, correctedValue) -> LOGGER.warn(Logging.CORE, "Incorrect key {} was corrected from {} to its default, {}. {}", (Object)DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> LOGGER.debug(Logging.CORE, "The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)));
            config.save();
        }
        this.afterReload();
    }

    public void validateSpec(ModConfig config) {
        this.forEachValue(this.getValues().valueMap().values(), configValue -> {
            if (!configValue.getSpec().restartType().isValid(config.getType())) {
                throw new IllegalArgumentException("Configuration value " + String.join((CharSequence)".", configValue.getPath()) + " defined in config " + config.getFileName() + " has restart of type " + String.valueOf((Object)configValue.getSpec().restartType()) + " which cannot be used for configs of type " + String.valueOf(config.getType()));
            }
        });
    }

    public boolean isLoaded() {
        return this.loadedConfig != null;
    }

    public UnmodifiableConfig getSpec() {
        return this.spec;
    }

    public UnmodifiableConfig getValues() {
        return this.values;
    }

    private void forEachValue(Iterable<Object> configValues, Consumer<ConfigValue<?>> consumer) {
        configValues.forEach(value -> {
            if (value instanceof ConfigValue) {
                ConfigValue configValue = (ConfigValue)value;
                consumer.accept(configValue);
            } else if (value instanceof Config) {
                Config innerConfig = (Config)value;
                this.forEachValue(innerConfig.valueMap().values(), consumer);
            }
        });
    }

    public void afterReload() {
        this.resetCaches(RestartType.NONE);
    }

    @ApiStatus.Internal
    public void resetCaches(RestartType restartType) {
        this.forEachValue(this.getValues().valueMap().values(), configValue -> {
            if (configValue.getSpec().restartType == restartType) {
                configValue.clearCache();
            }
        });
    }

    public void save() {
        Preconditions.checkNotNull((Object)this.loadedConfig, (Object)"Cannot save config value without assigned Config object present");
        this.loadedConfig.save();
    }

    public boolean isCorrect(UnmodifiableCommentedConfig config) {
        LinkedList<String> parentPath = new LinkedList<String>();
        return this.correct(this.spec, config, parentPath, Collections.unmodifiableList(parentPath), (a, b, c, d) -> {}, null, true) == 0;
    }

    public void correct(CommentedConfig config) {
        this.correct(config, (action, path, incorrectValue, correctedValue) -> {}, null);
    }

    public int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener) {
        return this.correct(config, listener, null);
    }

    public int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ConfigSpec.CorrectionListener commentListener) {
        LinkedList<String> parentPath = new LinkedList<String>();
        return this.correct(this.spec, (UnmodifiableCommentedConfig)config, parentPath, Collections.unmodifiableList(parentPath), listener, commentListener, false);
    }

    private int correct(UnmodifiableConfig spec, UnmodifiableCommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map specMap = spec.valueMap();
        Map configMap = config.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            String key = (String)specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            if (specValue instanceof Config) {
                if (configValue instanceof CommentedConfig) {
                    if ((count += this.correct((UnmodifiableConfig)((Config)specValue), (UnmodifiableCommentedConfig)((CommentedConfig)configValue), parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    if (dryRun) {
                        return 1;
                    }
                    CommentedConfig newValue = ((CommentedConfig)config).createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, (Object)newValue);
                    ++count;
                    count += this.correct((UnmodifiableConfig)((Config)specValue), (UnmodifiableCommentedConfig)newValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                }
                String newComment = this.levelComments.get(parentPath);
                oldComment = config.getComment(key);
                if (!this.stringsMatchNormalizingNewLines(oldComment, newComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)newComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    ((CommentedConfig)config).setComment(key, newComment);
                }
            } else {
                ValueSpec valueSpec = (ValueSpec)specValue;
                if (!valueSpec.test(configValue)) {
                    if (dryRun) {
                        return 1;
                    }
                    Object newValue = valueSpec.correct(configValue);
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                }
                if (!this.stringsMatchNormalizingNewLines(oldComment = config.getComment(key), valueSpec.getComment())) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)valueSpec.getComment());
                    }
                    if (dryRun) {
                        return 1;
                    }
                    ((CommentedConfig)config).setComment(key, valueSpec.getComment());
                }
            }
            parentPath.removeLast();
        }
        Iterator ittr = configMap.entrySet().iterator();
        while (ittr.hasNext()) {
            Map.Entry entry = ittr.next();
            if (specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            ittr.remove();
            parentPath.addLast((String)entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean stringsMatchNormalizingNewLines(@Nullable String string1, @Nullable String string2) {
        boolean blank2;
        boolean blank1 = string1 == null || string1.isBlank();
        boolean bl = blank2 = string2 == null || string2.isBlank();
        if (blank1 != blank2) {
            return false;
        }
        if (blank1 && blank2) {
            return true;
        }
        return string1.replaceAll("\r\n", "\n").equals(string2.replaceAll("\r\n", "\n"));
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public static enum RestartType {
        NONE(new ModConfig.Type[0]),
        WORLD(new ModConfig.Type[0]),
        GAME(ModConfig.Type.SERVER);

        private final Set<ModConfig.Type> invalidTypes = EnumSet.noneOf(ModConfig.Type.class);

        private RestartType(ModConfig.Type ... invalidTypes) {
            this.invalidTypes.addAll(Arrays.asList(invalidTypes));
        }

        private boolean isValid(ModConfig.Type type) {
            return !this.invalidTypes.contains(type);
        }

        public RestartType with(RestartType other) {
            return other == NONE ? this : (other == GAME || this == GAME ? GAME : WORLD);
        }
    }

    public static class ValueSpec {
        private final @Nullable String comment;
        private final @Nullable String langKey;
        private final @Nullable Range<?> range;
        private final @Nullable Class<?> clazz;
        private final Supplier<?> supplier;
        private final Predicate<Object> validator;
        private final RestartType restartType;

        private ValueSpec(Supplier<?> supplier, Predicate<Object> validator, BuilderContext context, List<String> path) {
            Objects.requireNonNull(supplier, "Default supplier can not be null");
            Objects.requireNonNull(validator, "Validator can not be null");
            this.comment = context.hasComment() ? context.buildComment(path) : null;
            this.langKey = context.getTranslationKey();
            this.range = context.getRange();
            this.restartType = context.restartType();
            this.clazz = context.getClazz();
            this.supplier = supplier;
            this.validator = validator;
        }

        public @Nullable String getComment() {
            return this.comment;
        }

        public @Nullable String getTranslationKey() {
            return this.langKey;
        }

        public <V extends Comparable<? super V>> @Nullable Range<V> getRange() {
            return this.range;
        }

        public RestartType restartType() {
            return this.restartType;
        }

        public @Nullable Class<?> getClazz() {
            return this.clazz;
        }

        public boolean test(@Nullable Object value) {
            return this.validator.test(value);
        }

        public Object correct(@Nullable Object value) {
            return this.range == null ? this.getDefault() : this.range.correct(value, this.getDefault());
        }

        public Object getDefault() {
            return this.supplier.get();
        }
    }

    public static class ConfigValue<T>
    implements Supplier<T> {
        private final Builder parent;
        private final List<String> path;
        private final Supplier<T> defaultSupplier;
        private @Nullable T cachedValue = null;
        private @Nullable ModConfigSpec spec;

        ConfigValue(Builder parent, List<String> path, Supplier<T> defaultSupplier) {
            this.parent = parent;
            this.path = path;
            this.defaultSupplier = defaultSupplier;
            this.parent.values.add(this);
        }

        public List<String> getPath() {
            return Lists.newArrayList(this.path);
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.getRaw();
            }
            return this.cachedValue;
        }

        public T getRaw() {
            Preconditions.checkNotNull((Object)this.spec, (Object)"Cannot get config value before spec is built");
            IConfigSpec.ILoadedConfig loadedConfig = this.spec.loadedConfig;
            Preconditions.checkState((loadedConfig != null ? 1 : 0) != 0, (Object)"Cannot get config value before config is loaded.");
            return this.getRaw((Config)loadedConfig.config(), this.path, this.defaultSupplier);
        }

        public T getRaw(Config config, List<String> path, Supplier<T> defaultSupplier) {
            return (T)config.getOrElse(path, defaultSupplier);
        }

        public T getDefault() {
            return this.defaultSupplier.get();
        }

        public Builder next() {
            return this.parent;
        }

        public void save() {
            Preconditions.checkNotNull((Object)this.spec, (Object)"Cannot save config value before spec is built");
            Preconditions.checkNotNull((Object)this.spec.loadedConfig, (Object)"Cannot save config value without assigned Config object present");
            this.spec.save();
        }

        public void set(T value) {
            Preconditions.checkNotNull((Object)this.spec, (Object)"Cannot set config value before spec is built");
            IConfigSpec.ILoadedConfig loadedConfig = this.spec.loadedConfig;
            Preconditions.checkNotNull((Object)loadedConfig, (Object)"Cannot set config value without assigned Config object present");
            loadedConfig.config().set(this.path, value);
            if (this.getSpec().restartType == RestartType.NONE) {
                this.cachedValue = value;
            }
        }

        public ValueSpec getSpec() {
            return (ValueSpec)this.parent.spec.get(this.path);
        }

        public void clearCache() {
            this.cachedValue = null;
        }
    }

    public static class EnumValue<T extends Enum<T>>
    extends ConfigValue<T> {
        private final EnumGetMethod converter;
        private final Class<T> clazz;

        EnumValue(Builder parent, List<String> path, Supplier<T> defaultSupplier, EnumGetMethod converter, Class<T> clazz) {
            super(parent, path, defaultSupplier);
            this.converter = converter;
            this.clazz = clazz;
        }

        @Override
        public T getRaw(Config config, List<String> path, Supplier<T> defaultSupplier) {
            return (T)config.getEnumOrElse(path, this.clazz, this.converter, defaultSupplier);
        }
    }

    public static class DoubleValue
    extends ConfigValue<Double>
    implements DoubleSupplier {
        DoubleValue(Builder parent, List<String> path, Supplier<Double> defaultSupplier) {
            super(parent, path, defaultSupplier);
        }

        @Override
        public Double getRaw(Config config, List<String> path, Supplier<Double> defaultSupplier) {
            Number n = (Number)config.get(path);
            return n == null ? defaultSupplier.get().doubleValue() : n.doubleValue();
        }

        @Override
        public double getAsDouble() {
            return (Double)this.get();
        }
    }

    public static class LongValue
    extends ConfigValue<Long>
    implements LongSupplier {
        LongValue(Builder parent, List<String> path, Supplier<Long> defaultSupplier) {
            super(parent, path, defaultSupplier);
        }

        @Override
        public Long getRaw(Config config, List<String> path, Supplier<Long> defaultSupplier) {
            return config.getLongOrElse(path, () -> (Long)defaultSupplier.get());
        }

        @Override
        public long getAsLong() {
            return (Long)this.get();
        }
    }

    public static class IntValue
    extends ConfigValue<Integer>
    implements IntSupplier {
        IntValue(Builder parent, List<String> path, Supplier<Integer> defaultSupplier) {
            super(parent, path, defaultSupplier);
        }

        @Override
        public Integer getRaw(Config config, List<String> path, Supplier<Integer> defaultSupplier) {
            return config.getIntOrElse(path, () -> (Integer)defaultSupplier.get());
        }

        @Override
        public int getAsInt() {
            return (Integer)this.get();
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean>
    implements BooleanSupplier {
        BooleanValue(Builder parent, List<String> path, Supplier<Boolean> defaultSupplier) {
            super(parent, path, defaultSupplier);
        }

        @Override
        public boolean getAsBoolean() {
            return (Boolean)this.get();
        }

        public boolean isTrue() {
            return this.getAsBoolean();
        }

        public boolean isFalse() {
            return !this.getAsBoolean();
        }
    }

    public static class ListValueSpec
    extends ValueSpec {
        private static final Range<Integer> MAX_ELEMENTS = Range.of(0, Integer.MAX_VALUE);
        private static final Range<Integer> NON_EMPTY = Range.of(1, Integer.MAX_VALUE);
        private final @Nullable Supplier<?> newElementSupplier;
        private final @Nullable Range<Integer> sizeRange;
        private final Predicate<Object> elementValidator;

        private ListValueSpec(Supplier<?> supplier, @Nullable Supplier<?> newElementSupplier, Predicate<Object> listValidator, Predicate<Object> elementValidator, BuilderContext context, List<String> path, @Nullable Range<Integer> sizeRange) {
            super(supplier, listValidator, context, path);
            Objects.requireNonNull(elementValidator, "ElementValidator can not be null");
            this.newElementSupplier = newElementSupplier;
            this.elementValidator = elementValidator;
            this.sizeRange = Objects.requireNonNullElse(sizeRange, MAX_ELEMENTS);
        }

        public @Nullable Supplier<?> getNewElementSupplier() {
            return this.newElementSupplier;
        }

        public boolean testElement(Object value) {
            return this.elementValidator.test(value);
        }

        public Range<Integer> getSizeRange() {
            return this.sizeRange;
        }
    }

    public static class Range<V extends Comparable<? super V>>
    implements Predicate<Object> {
        private final Class<? extends V> clazz;
        private final V min;
        private final V max;

        private Range(Class<V> clazz, V min, V max) {
            this.clazz = clazz;
            this.min = min;
            this.max = max;
            if (min.compareTo(max) > 0) {
                throw new IllegalArgumentException("Range min must be less then max.");
            }
        }

        public static Range<Integer> of(int min, int max) {
            return new Range<Integer>(Integer.class, min, max);
        }

        public Class<? extends V> getClazz() {
            return this.clazz;
        }

        public V getMin() {
            return this.min;
        }

        public V getMax() {
            return this.max;
        }

        private boolean isNumber(@Nullable Object other) {
            return Number.class.isAssignableFrom(this.clazz) && other instanceof Number;
        }

        @Override
        public boolean test(Object t) {
            boolean result;
            if (this.isNumber(t)) {
                boolean result2;
                Number n = (Number)t;
                boolean bl = result2 = ((Number)this.min).doubleValue() <= n.doubleValue() && n.doubleValue() <= ((Number)this.max).doubleValue();
                if (!result2) {
                    LOGGER.debug(Logging.CORE, "Range value {} is not within its bounds {}-{}", (Object)n.doubleValue(), (Object)((Number)this.min).doubleValue(), (Object)((Number)this.max).doubleValue());
                }
                return result2;
            }
            if (!this.clazz.isInstance(t)) {
                return false;
            }
            Comparable c = (Comparable)this.clazz.cast(t);
            boolean bl = result = c.compareTo(this.min) >= 0 && c.compareTo(this.max) <= 0;
            if (!result) {
                LOGGER.debug(Logging.CORE, "Range value {} is not within its bounds {}-{}", (Object)c, this.min, this.max);
            }
            return result;
        }

        public Object correct(@Nullable Object value, Object def) {
            if (this.isNumber(value)) {
                Number n = (Number)value;
                return n.doubleValue() < ((Number)this.min).doubleValue() ? this.min : (n.doubleValue() > ((Number)this.max).doubleValue() ? this.max : value);
            }
            if (!this.clazz.isInstance(value)) {
                return def;
            }
            Comparable c = (Comparable)this.clazz.cast(value);
            return c.compareTo(this.min) < 0 ? this.min : (c.compareTo(this.max) > 0 ? this.max : value);
        }

        public String toString() {
            if (this.clazz == Integer.class) {
                if (this.max.equals(Integer.MAX_VALUE)) {
                    return "> " + String.valueOf(this.min);
                }
                if (this.min.equals(Integer.MIN_VALUE)) {
                    return "< " + String.valueOf(this.max);
                }
            }
            return String.valueOf(this.min) + " ~ " + String.valueOf(this.max);
        }
    }

    private static class BuilderContext {
        private final List<String> comment = new LinkedList<String>();
        private @Nullable String langKey;
        private @Nullable Range<?> range;
        private RestartType restartType = RestartType.NONE;
        private @Nullable Class<?> clazz;

        private BuilderContext() {
        }

        public void addComment(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"Passed in null value for comment");
            this.comment.add(value);
        }

        public void clearComment() {
            this.comment.clear();
        }

        public boolean hasComment() {
            return this.comment.size() > 0;
        }

        public String buildComment() {
            return this.buildComment(List.of("unknown", "unknown"));
        }

        public String buildComment(List<String> path) {
            if (this.comment.stream().allMatch(String::isBlank)) {
                if (!FMLEnvironment.isProduction()) {
                    throw new IllegalStateException("Can not build comment for config option " + DOT_JOINER.join(path) + " as it comprises entirely of blank lines/whitespace. This is not allowed as it causes a \"constantly correcting config\" bug with NightConfig in NeoForge's config system.");
                }
                LOGGER.warn(Logging.CORE, "Detected a comment that is all whitespace for config option {}, which causes obscure bugs in NeoForge's config system and will cause a crash in the future. Please report this to the mod author.", (Object)DOT_JOINER.join(path));
                return "A developer of this mod has defined this config option with a blank comment, which causes obscure bugs in NeoForge's config system and will cause a crash in the future. Please report this to the mod author.";
            }
            return LINE_JOINER.join(this.comment);
        }

        public void setTranslationKey(@Nullable String value) {
            this.langKey = value;
        }

        public @Nullable String getTranslationKey() {
            return this.langKey;
        }

        public <V extends Comparable<? super V>> void setRange(Range<V> value) {
            this.range = value;
            this.setClazz(value.getClazz());
        }

        public <V extends Comparable<? super V>> @Nullable Range<V> getRange() {
            return this.range;
        }

        public void worldRestart() {
            this.restartType = RestartType.WORLD;
        }

        public void gameRestart() {
            this.restartType = RestartType.GAME;
        }

        public RestartType restartType() {
            return this.restartType;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public @Nullable Class<?> getClazz() {
            return this.clazz;
        }

        public void ensureEmpty() {
            this.validate(this.hasComment(), "Non-empty comment when empty expected");
            this.validate(this.langKey, "Non-null translation key when null expected");
            this.validate(this.range, "Non-null range when null expected");
            this.validate(this.restartType != RestartType.NONE, "Dangling restart value set to " + String.valueOf((Object)this.restartType));
        }

        private void validate(@Nullable Object value, String message) {
            if (value != null) {
                throw new IllegalStateException(message);
            }
        }

        private void validate(boolean value, String message) {
            if (value) {
                throw new IllegalStateException(message);
            }
        }
    }

    public static class Builder {
        private final Config spec = Config.of(LinkedHashMap::new, (ConfigFormat)InMemoryFormat.withUniversalSupport());
        private BuilderContext context = new BuilderContext();
        private final Map<List<String>, String> levelComments = new HashMap<List<String>, String>();
        private final Map<List<String>, String> levelTranslationKeys = new HashMap<List<String>, String>();
        private final List<String> currentPath = new ArrayList<String>();
        private final List<ConfigValue<?>> values = new ArrayList();

        public <T> ConfigValue<T> define(String path, T defaultValue) {
            return this.define(ModConfigSpec.split(path), defaultValue);
        }

        public <T> ConfigValue<T> define(List<String> path, T defaultValue) {
            return this.define(path, defaultValue, (Object o) -> o != null && defaultValue.getClass().isAssignableFrom(o.getClass()));
        }

        public <T> ConfigValue<T> define(String path, T defaultValue, Predicate<Object> validator) {
            return this.define(ModConfigSpec.split(path), defaultValue, validator);
        }

        public <T> ConfigValue<T> define(List<String> path, T defaultValue, Predicate<Object> validator) {
            Objects.requireNonNull(defaultValue, "Default value can not be null");
            return this.define(path, () -> defaultValue, validator);
        }

        public <T> ConfigValue<T> define(String path, Supplier<T> defaultSupplier, Predicate<Object> validator) {
            return this.define(ModConfigSpec.split(path), defaultSupplier, validator);
        }

        public <T> ConfigValue<T> define(List<String> path, Supplier<T> defaultSupplier, Predicate<Object> validator) {
            return this.define(path, defaultSupplier, validator, Object.class);
        }

        public <T> ConfigValue<T> define(List<String> path, Supplier<T> defaultSupplier, Predicate<Object> validator, Class<?> clazz) {
            this.context.setClazz(clazz);
            return this.define(path, new ValueSpec(defaultSupplier, validator, this.context, path), defaultSupplier);
        }

        public <T> ConfigValue<T> define(List<String> path, ValueSpec value, Supplier<T> defaultSupplier) {
            if (!this.currentPath.isEmpty()) {
                ArrayList<String> tmp = new ArrayList<String>(this.currentPath.size() + path.size());
                tmp.addAll(this.currentPath);
                tmp.addAll(path);
                path = tmp;
            }
            this.spec.set(path, (Object)value);
            this.context = new BuilderContext();
            return new ConfigValue<T>(this, path, defaultSupplier);
        }

        public <V extends Comparable<? super V>> ConfigValue<V> defineInRange(String path, V defaultValue, V min, V max, Class<V> clazz) {
            return this.defineInRange(ModConfigSpec.split(path), defaultValue, min, max, clazz);
        }

        public <V extends Comparable<? super V>> ConfigValue<V> defineInRange(List<String> path, V defaultValue, V min, V max, Class<V> clazz) {
            return this.defineInRange(path, () -> defaultValue, min, max, clazz);
        }

        public <V extends Comparable<? super V>> ConfigValue<V> defineInRange(String path, Supplier<V> defaultSupplier, V min, V max, Class<V> clazz) {
            return this.defineInRange(ModConfigSpec.split(path), defaultSupplier, min, max, clazz);
        }

        public <V extends Comparable<? super V>> ConfigValue<V> defineInRange(List<String> path, Supplier<V> defaultSupplier, V min, V max, Class<V> clazz) {
            Range<V> range = new Range<V>(clazz, min, max);
            this.context.setRange(range);
            this.comment(" Default: " + String.valueOf(defaultSupplier.get()));
            this.comment(" Range: " + String.valueOf(range));
            return this.define(path, (Supplier)defaultSupplier, (Predicate<Object>)range);
        }

        public <T> ConfigValue<T> defineInList(String path, T defaultValue, Collection<? extends T> acceptableValues) {
            return this.defineInList(ModConfigSpec.split(path), defaultValue, acceptableValues);
        }

        public <T> ConfigValue<T> defineInList(String path, Supplier<T> defaultSupplier, Collection<? extends T> acceptableValues) {
            return this.defineInList(ModConfigSpec.split(path), defaultSupplier, acceptableValues);
        }

        public <T> ConfigValue<T> defineInList(List<String> path, T defaultValue, Collection<? extends T> acceptableValues) {
            return this.defineInList(path, () -> defaultValue, acceptableValues);
        }

        public <T> ConfigValue<T> defineInList(List<String> path, Supplier<T> defaultSupplier, Collection<? extends T> acceptableValues) {
            return this.define(path, defaultSupplier, acceptableValues::contains);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            return this.defineList(ModConfigSpec.split(path), defaultValue, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineList(String path, List<? extends T> defaultValue, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineList(ModConfigSpec.split(path), defaultValue, newElementSupplier, elementValidator);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineList(String path, Supplier<List<? extends T>> defaultSupplier, Predicate<Object> elementValidator) {
            return this.defineList(ModConfigSpec.split(path), defaultSupplier, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineList(String path, Supplier<List<? extends T>> defaultSupplier, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineList(ModConfigSpec.split(path), defaultSupplier, newElementSupplier, elementValidator);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineList(List<String> path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            return this.defineList(path, () -> defaultValue, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineList(List<String> path, List<? extends T> defaultValue, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineList(path, () -> defaultValue, newElementSupplier, elementValidator);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineList(List<String> path, Supplier<List<? extends T>> defaultSupplier, Predicate<Object> elementValidator) {
            return this.defineList(path, defaultSupplier, null, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineList(List<String> path, Supplier<List<? extends T>> defaultSupplier, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineList(path, defaultSupplier, newElementSupplier, elementValidator, ListValueSpec.NON_EMPTY);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(ModConfigSpec.split(path), defaultValue, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(String path, List<? extends T> defaultValue, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(ModConfigSpec.split(path), defaultValue, newElementSupplier, elementValidator);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(String path, Supplier<List<? extends T>> defaultSupplier, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(ModConfigSpec.split(path), defaultSupplier, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(String path, Supplier<List<? extends T>> defaultSupplier, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(ModConfigSpec.split(path), defaultSupplier, newElementSupplier, elementValidator);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(List<String> path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(path, () -> defaultValue, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(List<String> path, List<? extends T> defaultValue, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(path, () -> defaultValue, newElementSupplier, elementValidator);
        }

        @Deprecated
        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(List<String> path, Supplier<List<? extends T>> defaultSupplier, Predicate<Object> elementValidator) {
            return this.defineListAllowEmpty(path, defaultSupplier, null, elementValidator);
        }

        public <T> ConfigValue<List<? extends T>> defineListAllowEmpty(List<String> path, Supplier<List<? extends T>> defaultSupplier, Supplier<T> newElementSupplier, Predicate<Object> elementValidator) {
            return this.defineList(path, defaultSupplier, newElementSupplier, elementValidator, null);
        }

        public <T> ConfigValue<List<? extends T>> defineList(final List<String> path, Supplier<List<? extends T>> defaultSupplier, @Nullable Supplier<T> newElementSupplier, final Predicate<Object> elementValidator, @Nullable Range<Integer> sizeRange) {
            this.context.setClazz(List.class);
            return this.define(path, new ListValueSpec(this, defaultSupplier, newElementSupplier, x -> x instanceof List && ((List)x).stream().allMatch(elementValidator), elementValidator, this.context, path, sizeRange){
                {
                    Objects.requireNonNull(this$0);
                    super(supplier, newElementSupplier, listValidator, elementValidator2, context, path2, sizeRange);
                }

                @Override
                public Object correct(Object value) {
                    if (!(value instanceof List) || this.getSizeRange() != null && !this.getSizeRange().test((Object)((List)value).size())) {
                        LOGGER.debug(Logging.CORE, "List on key {} is deemed to need correction, as it is null, not a list, or the wrong size.", path.getLast());
                        return this.getDefault();
                    }
                    ArrayList list = Lists.newArrayList((Iterable)((List)value));
                    list.removeIf(elementValidator.negate());
                    if (list.isEmpty()) {
                        LOGGER.debug(Logging.CORE, "List on key {} is deemed to need correction. It failed validation.", path.getLast());
                        return this.getDefault();
                    }
                    return list;
                }
            }, defaultSupplier);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, EnumGetMethod converter) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, converter);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue) {
            return this.defineEnum(path, defaultValue, (Enum[])defaultValue.getDeclaringClass().getEnumConstants());
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, EnumGetMethod converter) {
            return this.defineEnum(path, defaultValue, converter, (Enum[])defaultValue.getDeclaringClass().getEnumConstants());
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, V ... acceptableValues) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, (Enum[])acceptableValues);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, EnumGetMethod converter, V ... acceptableValues) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, converter, (Enum[])acceptableValues);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, V ... acceptableValues) {
            return this.defineEnum(path, defaultValue, (Collection<V>)Arrays.asList(acceptableValues));
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, EnumGetMethod converter, V ... acceptableValues) {
            return this.defineEnum(path, defaultValue, converter, (Collection<V>)Arrays.asList(acceptableValues));
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, Collection<V> acceptableValues) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, acceptableValues);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, EnumGetMethod converter, Collection<V> acceptableValues) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, converter, acceptableValues);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, Collection<V> acceptableValues) {
            return this.defineEnum(path, defaultValue, EnumGetMethod.NAME_IGNORECASE, acceptableValues);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, EnumGetMethod converter, Collection<V> acceptableValues) {
            return this.defineEnum(path, defaultValue, converter, (Object obj) -> {
                if (obj instanceof Enum) {
                    return acceptableValues.contains(obj);
                }
                if (obj == null) {
                    return false;
                }
                try {
                    return acceptableValues.contains(converter.get(obj, defaultValue.getDeclaringClass()));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    return false;
                }
            });
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, Predicate<Object> validator) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, validator);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, V defaultValue, EnumGetMethod converter, Predicate<Object> validator) {
            return this.defineEnum(ModConfigSpec.split(path), defaultValue, converter, validator);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, Predicate<Object> validator) {
            return this.defineEnum(path, () -> defaultValue, validator, defaultValue.getDeclaringClass());
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, V defaultValue, EnumGetMethod converter, Predicate<Object> validator) {
            return this.defineEnum(path, () -> defaultValue, converter, validator, defaultValue.getDeclaringClass());
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, Supplier<V> defaultSupplier, Predicate<Object> validator, Class<V> clazz) {
            return this.defineEnum(ModConfigSpec.split(path), defaultSupplier, validator, clazz);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(String path, Supplier<V> defaultSupplier, EnumGetMethod converter, Predicate<Object> validator, Class<V> clazz) {
            return this.defineEnum(ModConfigSpec.split(path), defaultSupplier, converter, validator, clazz);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, Supplier<V> defaultSupplier, Predicate<Object> validator, Class<V> clazz) {
            return this.defineEnum(path, defaultSupplier, EnumGetMethod.NAME_IGNORECASE, validator, clazz);
        }

        public <V extends Enum<V>> EnumValue<V> defineEnum(List<String> path, Supplier<V> defaultSupplier, EnumGetMethod converter, Predicate<Object> validator, Class<V> clazz) {
            this.context.setClazz(clazz);
            Enum[] allowedValues = (Enum[])clazz.getEnumConstants();
            this.comment("Allowed Values: " + Arrays.stream(allowedValues).filter(validator).map(Enum::name).collect(Collectors.joining(", ")));
            return new EnumValue<V>(this, this.define(path, new ValueSpec(defaultSupplier, validator, this.context, path), defaultSupplier).getPath(), defaultSupplier, converter, clazz);
        }

        public BooleanValue define(String path, boolean defaultValue) {
            return this.define(ModConfigSpec.split(path), defaultValue);
        }

        public BooleanValue define(List<String> path, boolean defaultValue) {
            return this.define(path, () -> defaultValue);
        }

        public BooleanValue define(String path, Supplier<Boolean> defaultSupplier) {
            return this.define(ModConfigSpec.split(path), defaultSupplier);
        }

        public BooleanValue define(List<String> path, Supplier<Boolean> defaultSupplier) {
            return new BooleanValue(this, this.define(path, defaultSupplier, o -> {
                if (o instanceof String) {
                    return ((String)o).equalsIgnoreCase("true") || ((String)o).equalsIgnoreCase("false");
                }
                return o instanceof Boolean;
            }, Boolean.class).getPath(), defaultSupplier);
        }

        public DoubleValue defineInRange(String path, double defaultValue, double min, double max) {
            return this.defineInRange(ModConfigSpec.split(path), defaultValue, min, max);
        }

        public DoubleValue defineInRange(List<String> path, double defaultValue, double min, double max) {
            return this.defineInRange(path, () -> defaultValue, min, max);
        }

        public DoubleValue defineInRange(String path, Supplier<Double> defaultSupplier, double min, double max) {
            return this.defineInRange(ModConfigSpec.split(path), defaultSupplier, min, max);
        }

        public DoubleValue defineInRange(List<String> path, Supplier<Double> defaultSupplier, double min, double max) {
            return new DoubleValue(this, this.defineInRange(path, defaultSupplier, Double.valueOf(min), Double.valueOf(max), Double.class).getPath(), defaultSupplier);
        }

        public IntValue defineInRange(String path, int defaultValue, int min, int max) {
            return this.defineInRange(ModConfigSpec.split(path), defaultValue, min, max);
        }

        public IntValue defineInRange(List<String> path, int defaultValue, int min, int max) {
            return this.defineInRange(path, () -> defaultValue, min, max);
        }

        public IntValue defineInRange(String path, Supplier<Integer> defaultSupplier, int min, int max) {
            return this.defineInRange(ModConfigSpec.split(path), defaultSupplier, min, max);
        }

        public IntValue defineInRange(List<String> path, Supplier<Integer> defaultSupplier, int min, int max) {
            return new IntValue(this, this.defineInRange(path, defaultSupplier, Integer.valueOf(min), Integer.valueOf(max), Integer.class).getPath(), defaultSupplier);
        }

        public LongValue defineInRange(String path, long defaultValue, long min, long max) {
            return this.defineInRange(ModConfigSpec.split(path), defaultValue, min, max);
        }

        public LongValue defineInRange(List<String> path, long defaultValue, long min, long max) {
            return this.defineInRange(path, () -> defaultValue, min, max);
        }

        public LongValue defineInRange(String path, Supplier<Long> defaultSupplier, long min, long max) {
            return this.defineInRange(ModConfigSpec.split(path), defaultSupplier, min, max);
        }

        public LongValue defineInRange(List<String> path, Supplier<Long> defaultSupplier, long min, long max) {
            return new LongValue(this, this.defineInRange(path, defaultSupplier, Long.valueOf(min), Long.valueOf(max), Long.class).getPath(), defaultSupplier);
        }

        public Builder comment(String comment) {
            this.context.addComment(comment);
            return this;
        }

        public Builder comment(String ... comment) {
            for (int i = 0; i < comment.length; ++i) {
                Preconditions.checkNotNull((Object)comment[i], (Object)("Comment string at " + i + " is null."));
            }
            for (String s : comment) {
                this.context.addComment(s);
            }
            return this;
        }

        public Builder translation(String translationKey) {
            this.context.setTranslationKey(translationKey);
            return this;
        }

        public Builder worldRestart() {
            this.context.worldRestart();
            return this;
        }

        public Builder gameRestart() {
            this.context.gameRestart();
            return this;
        }

        public Builder push(String path) {
            return this.push(ModConfigSpec.split(path));
        }

        public Builder push(List<String> path) {
            this.currentPath.addAll(path);
            if (this.context.hasComment()) {
                this.levelComments.put(new ArrayList<String>(this.currentPath), this.context.buildComment(path));
                this.context.clearComment();
            }
            if (this.context.getTranslationKey() != null) {
                this.levelTranslationKeys.put(new ArrayList<String>(this.currentPath), this.context.getTranslationKey());
                this.context.setTranslationKey(null);
            }
            this.context.ensureEmpty();
            return this;
        }

        public Builder pop() {
            return this.pop(1);
        }

        public Builder pop(int count) {
            if (count > this.currentPath.size()) {
                throw new IllegalArgumentException("Attempted to pop " + count + " elements when we only had: " + String.valueOf(this.currentPath));
            }
            for (int x = 0; x < count; ++x) {
                this.currentPath.remove(this.currentPath.size() - 1);
            }
            return this;
        }

        public <T> Pair<T, ModConfigSpec> configure(Function<Builder, T> consumer) {
            T o = consumer.apply(this);
            return Pair.of(o, (Object)this.build());
        }

        public ModConfigSpec build() {
            this.context.ensureEmpty();
            Config valueCfg = Config.of((Supplier)Config.getDefaultMapCreator((boolean)true, (boolean)true), (ConfigFormat)InMemoryFormat.withSupport(ConfigValue.class::isAssignableFrom));
            this.values.forEach(v -> valueCfg.set(v.getPath(), v));
            ModConfigSpec ret = new ModConfigSpec(this.spec.unmodifiable(), valueCfg.unmodifiable(), Collections.unmodifiableMap(this.levelComments), Collections.unmodifiableMap(this.levelTranslationKeys));
            this.values.forEach(v -> {
                v.spec = ret;
            });
            return ret;
        }
    }
}

