/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.quad;

import com.mojang.math.Quadrant;
import java.util.Objects;
import net.minecraft.client.model.geom.builders.UVPair;

public class UVTransform {
    private static final UVTransform[] TRANSFORMS = UVTransform.createTransforms();
    public static final UVTransform IDENTITY = UVTransform.of(Quadrant.R0, false, false);
    final int rotation;
    final boolean flipU;
    final boolean flipV;
    final Quadrant quadrant;

    private UVTransform(Quadrant rotation, boolean flipU, boolean flipV) {
        this.rotation = rotation.shift;
        this.quadrant = rotation;
        this.flipU = flipU;
        this.flipV = flipV;
    }

    public boolean isIdentity() {
        return this == IDENTITY;
    }

    public static UVTransform of(Quadrant rotation, boolean flipU, boolean flipV) {
        return TRANSFORMS[UVTransform.makeIndex(rotation.shift, flipU, flipV)];
    }

    public long transformPacked(long packedUv) {
        float u = UVPair.unpackU((long)packedUv);
        float v = UVPair.unpackV((long)packedUv);
        switch (this.rotation) {
            case 0: {
                break;
            }
            case 1: {
                float tmp = u;
                u = v;
                v = 1.0f - tmp;
                break;
            }
            case 2: {
                u = 1.0f - u;
                v = 1.0f - v;
                break;
            }
            case 3: {
                float tmp = u;
                u = 1.0f - v;
                v = tmp;
            }
        }
        if (this.flipU) {
            u = 1.0f - u;
        }
        if (this.flipV) {
            v = 1.0f - v;
        }
        return UVPair.pack((float)u, (float)v);
    }

    private static UVTransform[] createTransforms() {
        UVTransform[] result = new UVTransform[16];
        for (Quadrant quadrant : Quadrant.values()) {
            for (int flipU = 0; flipU < 2; ++flipU) {
                for (int flipV = 0; flipV < 2; ++flipV) {
                    UVTransform transform = new UVTransform(quadrant, flipU > 0, flipV > 0);
                    result[UVTransform.makeIndex((int)transform.rotation, (boolean)(flipU > 0 ? true : false), (boolean)(flipV > 0 ? true : false))] = transform;
                }
            }
        }
        for (UVTransform uVTransform : result) {
            Objects.requireNonNull(uVTransform);
        }
        return result;
    }

    private static int makeIndex(int rotation, boolean flipU, boolean flipV) {
        int result = rotation & 3;
        if (flipU) {
            result |= 4;
        }
        if (flipV) {
            result |= 8;
        }
        return result;
    }
}

