/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.neoforge.client.loading.ClientModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public class ModsButton
extends Button.Plain {
    private static final Identifier VERSION_CHECK_ICONS = Identifier.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/version_check_icons.png");
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable VersionChecker.Status showNotification;
    private boolean hasCheckedForUpdates = false;

    public ModsButton(Button.Builder builder) {
        super(builder);
    }

    protected void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderContents(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.hasCheckedForUpdates) {
            this.showNotification = ClientModLoader.checkForUpdates();
            this.hasCheckedForUpdates = true;
        }
        if (this.showNotification == null || !this.showNotification.shouldDraw() || !FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.VERSION_CHECK)) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, VERSION_CHECK_ICONS, x + w - (h / 2 + 4), y + (h / 2 - 4), (float)(this.showNotification.getSheetOffset() * 8), this.showNotification.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64, 16);
    }
}

