/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.neoforge.client.gui.ModListScreen;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class ModListWidget
extends ObjectSelectionList<ModEntry> {
    private static final Identifier VERSION_CHECK_ICONS = Identifier.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/version_check_icons.png");
    private final int listWidth;
    private ModListScreen parent;

    private static String stripControlCodes(String value) {
        return StringUtil.stripColor((String)value);
    }

    public ModListWidget(ModListScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraftInstance();
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
    }

    protected int scrollBarX() {
        return this.listWidth;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        this.clearEntries();
        ModListWidget modListWidget = this;
        this.parent.buildModList(x$0 -> modListWidget.addEntry((AbstractSelectionList.Entry)x$0), mod -> new ModEntry(this, (ModContainer)mod, this.parent));
    }

    public class ModEntry
    extends ObjectSelectionList.Entry<ModEntry> {
        private final ModContainer container;
        private final ModListScreen parent;
        final /* synthetic */ ModListWidget this$0;

        ModEntry(ModListWidget this$0, ModContainer info, ModListScreen parent) {
            ModListWidget modListWidget = this$0;
            Objects.requireNonNull(modListWidget);
            this.this$0 = modListWidget;
            this.container = info;
            this.parent = parent;
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.container.getModInfo().getDisplayName()});
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            MutableComponent name = Component.literal((String)ModListWidget.stripControlCodes(this.container.getModInfo().getDisplayName()));
            MutableComponent version = Component.literal((String)ModListWidget.stripControlCodes(MavenVersionTranslator.artifactVersionToString((ArtifactVersion)this.container.getModInfo().getVersion())));
            VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.container.getModInfo());
            int left = this.getContentX();
            int top = this.getContentY();
            Font font = this.parent.getFontRenderer();
            guiGraphics.drawString(font, Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, this.this$0.listWidth)})), left + 3, top + 2, -1, false);
            FormattedCharSequence formattedCharSequence = Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)version, this.this$0.listWidth)}));
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, formattedCharSequence, left + 3, top + 2 + 9, -3355444, false);
            if (vercheck.status().shouldDraw()) {
                int entryHeight = this.getContentHeight();
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, VERSION_CHECK_ICONS, this.getX() + this.this$0.width - 12, top + entryHeight / 4, (float)(vercheck.status().getSheetOffset() * 8), vercheck.status().isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64, 16);
            }
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            this.parent.setSelected(this.isFocused() ? null : this);
            this.this$0.setSelected((AbstractSelectionList.Entry)(this.isFocused() ? null : this));
            return false;
        }

        public void setFocused(boolean focused) {
            if (focused) {
                this.parent.setSelected(this);
                this.this$0.setSelected((AbstractSelectionList.Entry)this);
            }
        }

        public boolean isFocused() {
            return this.this$0.getSelected() == this;
        }

        public IModInfo getInfo() {
            return this.container.getModInfo();
        }

        public ModContainer getContainer() {
            return this.container;
        }
    }
}

