/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.payload.SyncAttachmentsPayload;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.registries.callback.AddCallback;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@EventBusSubscriber(modid="neoforge")
@ApiStatus.Internal
public final class AttachmentSync {
    public static final Registry<AttachmentType<?>> SYNCED_ATTACHMENT_TYPES = new RegistryBuilder(ResourceKey.createRegistryKey((Identifier)Identifier.fromNamespaceAndPath((String)"neoforge", (String)"synced_attachment_types"))).sync(true).callback((registry, id, key, value) -> {
        if (!NeoForgeRegistries.ATTACHMENT_TYPES.containsKey(key.identifier()) || !NeoForgeRegistries.ATTACHMENT_TYPES.containsValue(value) || NeoForgeRegistries.ATTACHMENT_TYPES.getValue(key.identifier()) != value) {
            throw new IllegalStateException("Cannot add entries to the SYNCED_ATTACHMENT_TYPES registry directly.");
        }
    }).create();
    public static final AddCallback<AttachmentType<?>> ATTACHMENT_TYPE_ADD_CALLBACK = (registry, id, key, value) -> {
        if (value.syncHandler != null) {
            Registry.register(SYNCED_ATTACHMENT_TYPES, (Identifier)key.identifier(), (Object)value);
        }
    };

    private static SyncAttachmentsPayload.Target syncTarget(AttachmentHolder holder) {
        Record record;
        AttachmentHolder attachmentHolder = holder;
        Objects.requireNonNull(attachmentHolder);
        AttachmentHolder attachmentHolder2 = attachmentHolder;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockEntity.class, AttachmentHolder.AsField.class, Entity.class, Level.class}, (AttachmentHolder)attachmentHolder2, n)) {
                case 0: {
                    BlockEntity blockEntity = (BlockEntity)attachmentHolder2;
                    record = new SyncAttachmentsPayload.BlockEntityTarget(blockEntity.getBlockPos());
                    break block6;
                }
                case 1: {
                    AttachmentHolder.AsField asField = (AttachmentHolder.AsField)attachmentHolder2;
                    IAttachmentHolder iAttachmentHolder = asField.getExposedHolder();
                    if (!(iAttachmentHolder instanceof LevelChunk)) {
                        n = 2;
                        continue block6;
                    }
                    LevelChunk chunk = (LevelChunk)iAttachmentHolder;
                    record = new SyncAttachmentsPayload.ChunkTarget(chunk.getPos());
                    break block6;
                }
                case 2: {
                    Entity entity = (Entity)attachmentHolder2;
                    record = new SyncAttachmentsPayload.EntityTarget(entity.getId());
                    break block6;
                }
                case 3: {
                    Level ignored = (Level)attachmentHolder2;
                    record = new SyncAttachmentsPayload.LevelTarget();
                    break block6;
                }
                default: {
                    throw new UnsupportedOperationException("Attachment holder class is not supported: " + String.valueOf(holder));
                }
            }
            break;
        }
        return record;
    }

    private static <T> void syncUpdate(AttachmentHolder holder, AttachmentType<T> type, List<ServerPlayer> players) {
        RegistryAccess registryAccess = null;
        for (ServerPlayer player : players) {
            if (!type.syncHandler.sendToPlayer(holder.getExposedHolder(), player)) continue;
            registryAccess = player.registryAccess();
            break;
        }
        if (registryAccess == null) {
            return;
        }
        byte[] data = FriendlyByteBufUtil.writeCustomData(buf -> {
            Object existingData = holder.getExistingDataOrNull(type);
            if (existingData != null) {
                buf.writeBoolean(true);
                type.syncHandler.write((RegistryFriendlyByteBuf)buf, holder.getData(type), false);
            } else {
                buf.writeBoolean(false);
            }
        }, registryAccess);
        ClientboundCustomPayloadPacket packet = new SyncAttachmentsPayload(AttachmentSync.syncTarget(holder), List.of(type), data).toVanillaClientbound();
        for (ServerPlayer player : players) {
            if (!type.syncHandler.sendToPlayer(holder.getExposedHolder(), player)) continue;
            player.connection.send((Packet)packet);
        }
    }

    public static void syncBlockEntityUpdate(BlockEntity blockEntity, AttachmentType<?> type) {
        Level level;
        if (type.syncHandler == null || !((level = blockEntity.getLevel()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AttachmentSync.syncUpdate((AttachmentHolder)blockEntity, type, serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(blockEntity.getBlockPos()), false));
    }

    public static void syncChunkUpdate(LevelChunk chunk, AttachmentHolder.AsField holder, AttachmentType<?> type) {
        Level level;
        if (type.syncHandler == null || !((level = chunk.getLevel()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AttachmentSync.syncUpdate(holder, type, serverLevel.getChunkSource().chunkMap.getPlayers(chunk.getPos(), false));
    }

    public static void syncEntityUpdate(Entity entity, AttachmentType<?> type) {
        Level level;
        if (type.syncHandler == null || !((level = entity.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList players = serverLevel.getChunkSource().chunkMap.getPlayersWatching(entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ArrayList newPlayers = new ArrayList(players.size() + 1);
            newPlayers.addAll(players);
            newPlayers.add(serverPlayer);
            players = newPlayers;
        }
        AttachmentSync.syncUpdate((AttachmentHolder)entity, type, players);
    }

    public static void syncLevelUpdate(ServerLevel level, AttachmentType<?> type) {
        if (type.syncHandler == null) {
            return;
        }
        AttachmentSync.syncUpdate((AttachmentHolder)level, type, level.players());
    }

    private static @Nullable SyncAttachmentsPayload syncInitialAttachments(AttachmentHolder holder, ServerPlayer to) {
        if (holder.attachments == null) {
            return null;
        }
        boolean anySyncableAttachment = false;
        for (AttachmentType<?> attachment : holder.attachments.keySet()) {
            anySyncableAttachment |= attachment.syncHandler != null;
        }
        if (!anySyncableAttachment) {
            return null;
        }
        ArrayList syncedTypes = new ArrayList();
        byte[] data = FriendlyByteBufUtil.writeCustomData(buf -> {
            for (Map.Entry<AttachmentType<?>, Object> entry : holder.attachments.entrySet()) {
                AttachmentType<?> type = entry.getKey();
                AttachmentSyncHandler<Object> syncHandler = type.syncHandler;
                if (syncHandler == null) continue;
                int indexBefore = buf.writerIndex();
                buf.writeBoolean(true);
                int indexBetween = buf.writerIndex();
                syncHandler.write((RegistryFriendlyByteBuf)buf, entry.getValue(), true);
                if (indexBetween < buf.writerIndex()) {
                    syncedTypes.add(type);
                    continue;
                }
                buf.writerIndex(indexBefore);
            }
        }, to.registryAccess());
        return new SyncAttachmentsPayload(AttachmentSync.syncTarget(holder), syncedTypes, data);
    }

    @SubscribeEvent
    public static void onChunkSent(ChunkWatchEvent.Sent event) {
        ArrayList<ClientboundCustomPayloadPacket> packets = new ArrayList<ClientboundCustomPayloadPacket>();
        SyncAttachmentsPayload chunkPayload = AttachmentSync.syncInitialAttachments(event.getChunk().getAttachmentHolder(), event.getPlayer());
        if (chunkPayload != null) {
            packets.add(chunkPayload.toVanillaClientbound());
        }
        for (BlockEntity blockEntity : event.getChunk().getBlockEntities().values()) {
            SyncAttachmentsPayload blockEntityPayload = AttachmentSync.syncInitialAttachments((AttachmentHolder)blockEntity, event.getPlayer());
            if (blockEntityPayload == null) continue;
            packets.add(blockEntityPayload.toVanillaClientbound());
        }
        if (!packets.isEmpty()) {
            event.getPlayer().connection.send((Packet)new ClientboundBundlePacket(packets));
        }
    }

    public static void syncInitialEntityAttachments(Entity entity, ServerPlayer to, Consumer<Packet<? super ClientGamePacketListener>> packetConsumer) {
        SyncAttachmentsPayload packet = AttachmentSync.syncInitialAttachments((AttachmentHolder)entity, to);
        if (packet != null) {
            packetConsumer.accept((Packet<? super ClientGamePacketListener>)packet.toVanillaClientbound());
        }
    }

    public static void syncInitialPlayerAttachments(ServerPlayer player) {
        SyncAttachmentsPayload packet = AttachmentSync.syncInitialAttachments((AttachmentHolder)player, player);
        if (packet != null) {
            player.connection.send((Packet)packet.toVanillaClientbound());
        }
    }

    public static void syncInitialLevelAttachments(ServerLevel level, ServerPlayer to) {
        SyncAttachmentsPayload packet = AttachmentSync.syncInitialAttachments((AttachmentHolder)level, to);
        if (packet != null) {
            to.connection.send((Packet)packet.toVanillaClientbound());
        }
    }

    public static void receiveSyncedDataAttachments(AttachmentHolder holder, RegistryAccess registryAccess, List<AttachmentType<?>> types, byte[] bytes) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes), registryAccess, ConnectionType.NEOFORGE);
        try {
            for (AttachmentType<?> type : types) {
                Object result;
                AttachmentSyncHandler<Object> syncHandler = type.syncHandler;
                if (syncHandler == null) {
                    throw new IllegalArgumentException("Received synced attachment type without a sync handler registered: " + String.valueOf(NeoForgeRegistries.ATTACHMENT_TYPES.getKey(type)));
                }
                Object previousValue = holder.attachments == null ? null : holder.attachments.get(type);
                boolean hasAttachment = buf.readBoolean();
                Object object = result = hasAttachment ? syncHandler.read(holder.getExposedHolder(), buf, previousValue) : null;
                if (result == null) {
                    if (holder.attachments == null) continue;
                    holder.attachments.remove(type);
                    continue;
                }
                holder.getAttachmentMap().put(type, result);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Encountered exception when reading synced data attachments: " + String.valueOf(types), exception);
        }
        finally {
            buf.release();
        }
    }

    private AttachmentSync() {
    }
}

