/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.FluidResourceHandlerItemAdapter;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.BlockWrapper;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import org.jspecify.annotations.Nullable;

@Deprecated(since="1.21.9", forRemoval=true)
public class FluidUtil {
    private FluidUtil() {
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, Level level, BlockPos pos, @Nullable Direction side) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)pos);
        return FluidUtil.getFluidHandler(level, pos, side).map(handler -> FluidUtil.interactWithFluidHandler(player, hand, handler)).orElse(false);
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, IFluidHandler handler) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty()) {
            return false;
        }
        PlayerInvWrapper playerInventory = new PlayerInvWrapper(player.getInventory());
        FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
        if (!fluidActionResult.isSuccess()) {
            fluidActionResult = FluidUtil.tryEmptyContainerAndStow(heldItem, handler, playerInventory, Integer.MAX_VALUE, player, true);
        }
        if (fluidActionResult.isSuccess()) {
            player.setItemInHand(hand, fluidActionResult.getResult());
            return true;
        }
        return false;
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidActionResult tryFillContainer(ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = container.copyWithCount(1);
        return FluidUtil.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false);
            if (!simulatedTransfer.isEmpty()) {
                if (doFill) {
                    SoundEvent soundevent;
                    FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true);
                    if (player != null && (soundevent = simulatedTransfer.getFluidType().getSound(simulatedTransfer, SoundActions.BUCKET_FILL)) != null) {
                        player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    containerFluidHandler.fill(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidActionResult tryEmptyContainer(ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = container.copyWithCount(1);
        return FluidUtil.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            SoundEvent soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            if (doDrain && player != null && (soundevent = transfer.getFluidType().getSound(transfer, SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidActionResult tryFillContainerAndStow(ItemStack container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doFill) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.getAbilities().instabuild) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).isEmpty() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, doFill);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal.getResult(), !doFill);
                if (!remainder.isEmpty() && player != null && doFill) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidActionResult tryEmptyContainerAndStow(ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable Player player, boolean doDrain) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.getAbilities().instabuild) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).isEmpty() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal.getResult(), !doDrain);
                if (!remainder.isEmpty() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty()) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && FluidStack.isSameFluidSameComponents(resource, drainable)) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return FluidStack.EMPTY;
    }

    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount > 0) {
            drainable.setAmount(fillableAmount);
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(drainable, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                    return drained;
                }
            } else {
                return drainable;
            }
        }
        return FluidStack.EMPTY;
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static Optional<IFluidHandlerItem> getFluidHandler(ItemStack itemStack) {
        ResourceHandler<ItemResource> container = VanillaContainerWrapper.of((Container)new SimpleContainer(new ItemStack[]{itemStack}){

            public void setItem(int slot, ItemStack stack, boolean performSideEffects) {
                this.getItems().set(slot, (Object)stack);
            }
        });
        ItemAccess itemAccess = ItemAccess.forHandlerIndex(container, 0);
        ResourceHandler<FluidResource> resourceHandler = itemAccess.getCapability(Capabilities.Fluid.ITEM);
        if (resourceHandler == null) {
            return Optional.empty();
        }
        return Optional.of(new FluidResourceHandlerItemAdapter(resourceHandler, itemAccess));
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static Optional<FluidStack> getFluidContained(ItemStack container) {
        Optional<FluidStack> fluidContained;
        if (!container.isEmpty() && (fluidContained = FluidUtil.getFluidHandler(container = container.copyWithCount(1)).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))).isPresent() && !fluidContained.get().isEmpty()) {
            return fluidContained;
        }
        return Optional.empty();
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static Optional<IFluidHandler> getFluidHandler(Level level, BlockPos blockPos, @Nullable Direction side) {
        ResourceHandler resourceHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, blockPos, (Object)side);
        if (resourceHandler == null) {
            return Optional.empty();
        }
        return Optional.of(IFluidHandler.of(resourceHandler));
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidActionResult tryPickUpFluid(ItemStack emptyContainer, @Nullable Player playerIn, Level level, BlockPos pos, Direction side) {
        IFluidHandler targetFluidHandler;
        if (emptyContainer.isEmpty() || level == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BucketPickup) {
            targetFluidHandler = new BucketPickupHandlerWrapper(playerIn, (BucketPickup)block, level, pos);
        } else {
            Optional<IFluidHandler> fluidHandler = FluidUtil.getFluidHandler(level, pos, side);
            if (!fluidHandler.isPresent()) {
                return FluidActionResult.FAILURE;
            }
            targetFluidHandler = fluidHandler.get();
        }
        return FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static FluidActionResult tryPlaceFluid(@Nullable Player player, Level level, InteractionHand hand, BlockPos pos, ItemStack container, FluidStack resource) {
        ItemStack containerCopy = container.copyWithCount(1);
        return FluidUtil.getFluidHandler(containerCopy).filter(handler -> FluidUtil.tryPlaceFluid(player, level, hand, pos, handler, resource)).map(IFluidHandlerItem::getContainer).map(FluidActionResult::new).orElse(FluidActionResult.FAILURE);
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static boolean tryPlaceFluid(@Nullable Player player, Level level, InteractionHand hand, BlockPos pos, IFluidHandler fluidSource, FluidStack resource) {
        boolean canDestContainFluid;
        if (level == null || pos == null) {
            return false;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == Fluids.EMPTY || !fluid.getFluidType().canBePlacedInLevel((BlockAndTintGetter)level, pos, resource)) {
            return false;
        }
        if (fluidSource.drain(resource, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return false;
        }
        BlockPlaceContext context = new BlockPlaceContext(level, player, hand, player == null ? ItemStack.EMPTY : player.getItemInHand(hand), new BlockHitResult(Vec3.ZERO, Direction.UP, pos, false));
        BlockState destBlockState = level.getBlockState(pos);
        boolean isDestNonSolid = !destBlockState.isSolid();
        boolean isDestReplaceable = destBlockState.canBeReplaced(context);
        boolean bl = canDestContainFluid = destBlockState.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)destBlockState.getBlock()).canPlaceLiquid((LivingEntity)player, (BlockGetter)level, pos, destBlockState, fluid);
        if (!(level.isEmptyBlock(pos) || isDestNonSolid || isDestReplaceable || canDestContainFluid)) {
            return false;
        }
        if (fluid.getFluidType().isVaporizedOnPlacement(level, pos, resource)) {
            FluidStack result = fluidSource.drain(resource, IFluidHandler.FluidAction.EXECUTE);
            if (!result.isEmpty()) {
                result.getFluidType().onVaporize((LivingEntity)player, level, pos, result);
                return true;
            }
        } else {
            IFluidHandler handler = canDestContainFluid ? new BlockWrapper.LiquidContainerBlockWrapper((LiquidBlockContainer)destBlockState.getBlock(), level, pos) : FluidUtil.getFluidBlockHandler(fluid, level, pos);
            FluidStack result = FluidUtil.tryFluidTransfer(handler, fluidSource, resource, true);
            if (!result.isEmpty()) {
                SoundEvent soundevent = resource.getFluidType().getSound(resource, SoundActions.BUCKET_EMPTY);
                if (soundevent != null) {
                    level.playSound((Entity)player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private static IFluidHandler getFluidBlockHandler(Fluid fluid, Level level, BlockPos pos) {
        BlockState state = fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)level, pos, fluid.defaultFluidState());
        return new BlockWrapper(state, level, pos);
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static void destroyBlockOnFluidPlacement(Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            BlockState destBlockState = level.getBlockState(pos);
            boolean isDestNonSolid = !destBlockState.isSolid();
            boolean isDestReplaceable = false;
            if ((isDestNonSolid || isDestReplaceable) && !destBlockState.liquid()) {
                level.destroyBlock(pos, true);
            }
        }
    }

    @Deprecated(since="1.21.9", forRemoval=true)
    public static ItemStack getFilledBucket(FluidStack fluidStack) {
        if (fluidStack.getComponents().isEmpty()) {
            if (fluidStack.is(Fluids.WATER)) {
                return new ItemStack((ItemLike)Items.WATER_BUCKET);
            }
            if (fluidStack.is(Fluids.LAVA)) {
                return new ItemStack((ItemLike)Items.LAVA_BUCKET);
            }
        }
        return fluidStack.getFluidType().getBucket(fluidStack);
    }
}

