/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.RenderTypeGroup;

public final class RenderTypeHelper {
    public static RenderType getEntityRenderType(ChunkSectionLayer chunkSectionLayer) {
        if (chunkSectionLayer != ChunkSectionLayer.TRANSLUCENT) {
            return Sheets.cutoutBlockSheet();
        }
        return Sheets.translucentBlockItemSheet();
    }

    public static RenderType getMovingBlockRenderType(ChunkSectionLayer chunkSectionLayer) {
        return switch (chunkSectionLayer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> RenderTypes.solidMovingBlock();
            case ChunkSectionLayer.CUTOUT -> RenderTypes.cutoutMovingBlock();
            case ChunkSectionLayer.TRANSLUCENT -> RenderTypes.translucentMovingBlock();
            case ChunkSectionLayer.TRIPWIRE -> RenderTypes.tripwireMovingBlock();
        };
    }

    public static Function<ItemStack, RenderType> detectItemModelRenderType(List<BakedQuad> quads, RenderTypeGroup renderTypes) {
        Iterator<BakedQuad> iterator = quads.iterator();
        if (!iterator.hasNext()) {
            return $ -> renderTypes.entityItem();
        }
        Identifier atlasId = iterator.next().sprite().atlasLocation();
        while (iterator.hasNext()) {
            Identifier currAtlasId = iterator.next().sprite().atlasLocation();
            if (currAtlasId.equals((Object)atlasId)) continue;
            throw new IllegalStateException("Multiple atlases used in model, expected " + String.valueOf(atlasId) + ", but also got " + String.valueOf(currAtlasId));
        }
        if (atlasId.equals((Object)TextureAtlas.LOCATION_ITEMS)) {
            return $ -> renderTypes.entityItem();
        }
        if (atlasId.equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return $ -> renderTypes.entityBlock();
        }
        throw new IllegalArgumentException("Atlas " + String.valueOf(atlasId) + " can't be used for item models");
    }

    private RenderTypeHelper() {
    }
}

