/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class StacksResourceHandler<S, T extends Resource>
implements ResourceHandler<T>,
ValueIOSerializable {
    public static final String VALUE_IO_KEY = "stacks";
    protected final S emptyStack;
    protected NonNullList<S> stacks;
    protected final Codec<NonNullList<S>> codec;
    private final List<StackJournal> snapshotJournals;

    protected StacksResourceHandler(int size, S emptyStack, Codec<S> stackCodec) {
        this(NonNullList.withSize((int)size, emptyStack), emptyStack, stackCodec);
    }

    protected StacksResourceHandler(NonNullList<S> stacks, S emptyStack, Codec<S> stackCodec) {
        this.emptyStack = emptyStack;
        this.stacks = this.mutableCopyOf((Collection<S>)stacks);
        this.codec = stackCodec.listOf().xmap(this::mutableCopyOf, Function.identity());
        this.snapshotJournals = new ArrayList<StackJournal>(this.stacks.size());
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.snapshotJournals.add(new StackJournal(this, i));
        }
    }

    private NonNullList<S> mutableCopyOf(Collection<S> list) {
        return NonNullList.of(this.emptyStack, (Object[])list.toArray(Object[]::new));
    }

    @Override
    public void serialize(ValueOutput output) {
        output.store(VALUE_IO_KEY, this.codec, this.stacks);
    }

    @Override
    public void deserialize(ValueInput input) {
        input.read(VALUE_IO_KEY, this.codec).ifPresent(l -> {
            this.stacks = l;
        });
    }

    public void set(int index, T resource, int amount) {
        TransferPreconditions.checkNonNegative(amount);
        if (resource.isEmpty() && amount > 0) {
            throw new IllegalArgumentException("Resource is empty but the amount is positive: " + amount);
        }
        Object oldContents = this.stacks.set(index, this.getStackFrom(resource, amount));
        this.onContentsChanged(index, oldContents);
    }

    protected abstract T getResourceFrom(S var1);

    protected abstract int getAmountFrom(S var1);

    protected abstract S getStackFrom(T var1, int var2);

    protected abstract S copyOf(S var1);

    protected boolean matches(S stack, T resource) {
        return this.getResourceFrom(stack).equals(resource);
    }

    @Override
    public boolean isValid(int index, T resource) {
        return true;
    }

    protected abstract int getCapacity(int var1, T var2);

    protected void onContentsChanged(int index, S previousContents) {
    }

    public NonNullList<S> copyToList() {
        return this.mutableCopyOf((Collection<S>)this.stacks);
    }

    @Override
    public int size() {
        return this.stacks.size();
    }

    @Override
    public T getResource(int index) {
        Objects.checkIndex(index, this.size());
        return this.getResourceFrom(this.stacks.get(index));
    }

    @Override
    public long getAmountAsLong(int index) {
        Objects.checkIndex(index, this.size());
        return this.getAmountFrom(this.stacks.get(index));
    }

    @Override
    public long getCapacityAsLong(int index, T resource) {
        Objects.checkIndex(index, this.size());
        return resource.isEmpty() || this.isValid(index, resource) ? (long)this.getCapacity(index, resource) : 0L;
    }

    @Override
    public int insert(int index, T resource, int amount, TransactionContext transaction) {
        int inserted;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        Object currentStack = this.stacks.get(index);
        int currentAmount = this.getAmountFrom(currentStack);
        if ((currentAmount == 0 || this.matches(currentStack, resource)) && this.isValid(index, resource) && (inserted = Math.min(amount, this.getCapacity(index, resource) - currentAmount)) > 0) {
            this.snapshotJournals.get(index).updateSnapshots(transaction);
            this.stacks.set(index, this.getStackFrom(resource, currentAmount + inserted));
            return inserted;
        }
        return 0;
    }

    @Override
    public int extract(int index, T resource, int amount, TransactionContext transaction) {
        int currentAmount;
        int extracted;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        Object currentStack = this.stacks.get(index);
        if (this.matches(currentStack, resource) && (extracted = Math.min(amount, currentAmount = this.getAmountFrom(currentStack))) > 0) {
            this.snapshotJournals.get(index).updateSnapshots(transaction);
            this.stacks.set(index, this.getStackFrom(resource, currentAmount - extracted));
            return extracted;
        }
        return 0;
    }

    private class StackJournal
    extends SnapshotJournal<S> {
        private final int index;
        final /* synthetic */ StacksResourceHandler this$0;

        private StackJournal(StacksResourceHandler stacksResourceHandler, int index) {
            StacksResourceHandler stacksResourceHandler2 = stacksResourceHandler;
            Objects.requireNonNull(stacksResourceHandler2);
            this.this$0 = stacksResourceHandler2;
            this.index = index;
        }

        @Override
        protected S createSnapshot() {
            return this.this$0.copyOf(this.this$0.stacks.get(this.index));
        }

        @Override
        protected void revertToSnapshot(S snapshot) {
            this.this$0.stacks.set(this.index, snapshot);
        }

        @Override
        protected void onRootCommit(S originalState) {
            this.this$0.onContentsChanged(this.index, originalState);
        }
    }
}

