/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command.generation;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.server.command.generation.CoarseOnionIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenerationTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BATCH_SIZE = 32;
    private static final int QUEUE_THRESHOLD = 8;
    private static final int COARSE_CELL_SIZE = 4;
    private final MinecraftServer server;
    private final ServerChunkCache chunkSource;
    private final ServerLevel serverLevel;
    private final Iterator<ChunkPos> iterator;
    private final int x;
    private final int z;
    private final int radius;
    private final int totalCount;
    private final Object queueLock = new Object();
    private final AtomicInteger queuedCount = new AtomicInteger();
    private final AtomicInteger okCount = new AtomicInteger();
    private final AtomicInteger errorCount = new AtomicInteger();
    private final AtomicInteger skippedCount = new AtomicInteger();
    private volatile Listener listener;
    private volatile boolean stopped;

    public GenerationTask(ServerLevel serverLevel, int x, int z, int radius) {
        this.server = serverLevel.getServer();
        this.chunkSource = serverLevel.getChunkSource();
        this.serverLevel = serverLevel;
        this.iterator = new CoarseOnionIterator(radius, 4);
        this.x = x;
        this.z = z;
        this.radius = radius;
        int diameter = radius * 2 + 1;
        this.totalCount = diameter * diameter;
    }

    public int getOkCount() {
        return this.okCount.get();
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public int getSkippedCount() {
        return this.skippedCount.get();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void run(Listener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("already running!");
        }
        this.listener = listener;
        CompletableFuture.runAsync(this::tryEnqueueTasks, (Executor)Util.backgroundExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.queueLock;
        synchronized (object) {
            this.stopped = true;
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryEnqueueTasks() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
            int enqueueCount = 32 - this.queuedCount.get();
            if (enqueueCount <= 0) {
                return;
            }
            LongList chunks = this.collectChunks(enqueueCount);
            if (chunks.isEmpty()) {
                this.listener.complete(this.errorCount.get());
                this.stopped = true;
                return;
            }
            this.queuedCount.getAndAdd(chunks.size());
            this.server.submit(() -> this.enqueueChunks(chunks));
        }
    }

    private void enqueueChunks(LongList chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            long chunk = chunks.getLong(i);
            this.acquireChunk(chunk);
        }
        this.chunkSource.tick(() -> false, true);
        ChunkMap chunkMap = this.chunkSource.chunkMap;
        for (int i = 0; i < chunks.size(); ++i) {
            long chunkLongPos = chunks.getLong(i);
            ChunkHolder holder = chunkMap.getVisibleChunkIfPresent(chunkLongPos);
            if (holder == null) {
                LOGGER.warn("Added ticket for chunk but it was not added! ({}; {})", (Object)ChunkPos.getX((long)chunkLongPos), (Object)ChunkPos.getZ((long)chunkLongPos));
                this.acceptChunkResult(chunkLongPos, (ChunkResult<ChunkAccess>)ChunkHolder.UNLOADED_CHUNK);
                continue;
            }
            holder.scheduleChunkGenerationTask(ChunkStatus.FULL, chunkMap).whenCompleteAsync((result, throwable) -> {
                if (throwable == null) {
                    this.acceptChunkResult(chunkLongPos, (ChunkResult<ChunkAccess>)result);
                } else {
                    LOGGER.warn("Encountered unexpected error while generating chunk", throwable);
                    this.acceptChunkResult(chunkLongPos, (ChunkResult<ChunkAccess>)ChunkHolder.UNLOADED_CHUNK);
                }
            }, runnable -> chunkMap.scheduleOnMainThreadMailbox(runnable));
        }
    }

    private void acceptChunkResult(long chunk, ChunkResult<ChunkAccess> result) {
        this.server.submit(() -> this.releaseChunk(chunk));
        if (result.isSuccess()) {
            this.okCount.getAndIncrement();
        } else {
            this.errorCount.getAndIncrement();
        }
        this.listener.update(this.okCount.get(), this.errorCount.get(), this.skippedCount.get(), this.totalCount);
        int queuedCount = this.queuedCount.decrementAndGet();
        if (queuedCount <= 8) {
            this.tryEnqueueTasks();
        }
        if ((this.okCount.get() + this.errorCount.get()) % 1000 == 999) {
            this.server.submit(() -> this.serverLevel.save(null, false, true));
        }
    }

    private LongList collectChunks(int count) {
        LongArrayList chunks = new LongArrayList(count);
        Iterator<ChunkPos> iterator = this.iterator;
        int i = 0;
        while (i < count && iterator.hasNext()) {
            ChunkPos chunkPosInLocalSpace = iterator.next();
            if (this.isChunkFullyGenerated(chunkPosInLocalSpace)) {
                this.skippedCount.incrementAndGet();
                this.listener.update(this.okCount.get(), this.errorCount.get(), this.skippedCount.get(), this.totalCount);
                continue;
            }
            chunks.add(ChunkPos.asLong((int)(chunkPosInLocalSpace.x + this.x), (int)(chunkPosInLocalSpace.z + this.z)));
            ++i;
        }
        return chunks;
    }

    private void acquireChunk(long chunk) {
        ChunkPos pos = new ChunkPos(chunk);
        this.chunkSource.addTicketWithRadius((TicketType)NeoForgeMod.GENERATE_FORCED_TICKET.value(), pos, 0);
    }

    private void releaseChunk(long chunk) {
        ChunkPos pos = new ChunkPos(chunk);
        this.chunkSource.removeTicketWithRadius((TicketType)NeoForgeMod.GENERATE_FORCED_TICKET.value(), pos, 0);
    }

    private boolean isChunkFullyGenerated(ChunkPos chunkPosInLocalSpace) {
        ChunkPos chunkPosInWorldSpace = new ChunkPos(chunkPosInLocalSpace.x + this.x, chunkPosInLocalSpace.z + this.z);
        CollectFields collectFields = new CollectFields(new FieldSelector[]{new FieldSelector(StringTag.TYPE, "Status")});
        this.chunkSource.chunkMap.chunkScanner().scanChunk(chunkPosInWorldSpace, (StreamTagVisitor)collectFields).join();
        Tag tag = collectFields.getResult();
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag.getString("Status").equals("minecraft:full");
        }
        return false;
    }

    public static interface Listener {
        public void update(int var1, int var2, int var3, int var4);

        public void complete(int var1);
    }
}

