/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.attachment.AttachmentSync;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record SyncAttachmentsPayload(Target target, List<AttachmentType<?>> types, byte[] syncPayload) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncAttachmentsPayload> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"neoforge", (String)"sync_attachments"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncAttachmentsPayload> STREAM_CODEC = StreamCodec.composite(Target.STREAM_CODEC, SyncAttachmentsPayload::target, (StreamCodec)ByteBufCodecs.registry((ResourceKey)AttachmentSync.SYNCED_ATTACHMENT_TYPES.key()).apply(ByteBufCodecs.list()), SyncAttachmentsPayload::types, NeoForgeStreamCodecs.UNBOUNDED_BYTE_ARRAY, SyncAttachmentsPayload::syncPayload, SyncAttachmentsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static sealed interface Target
    permits BlockEntityTarget, ChunkTarget, EntityTarget, LevelTarget {
        public static final StreamCodec<RegistryFriendlyByteBuf, Target> STREAM_CODEC = StreamCodec.of((buf, target) -> {
            Target target2 = target;
            Objects.requireNonNull(target2);
            Target selector4$temp = target2;
            int index$5 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockEntityTarget.class, ChunkTarget.class, EntityTarget.class, LevelTarget.class}, (Target)selector4$temp, index$5)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    BlockPos pos;
                    BlockEntityTarget $b$0 = (BlockEntityTarget)selector4$temp;
                    try {
                        BlockPos patt6$temp;
                        pos = patt6$temp = $b$0.pos();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    buf.writeByte(0);
                    buf.writeBlockPos(pos);
                    return;
                }
                case 1: {
                    ChunkPos pos;
                    ChunkTarget $b$1 = (ChunkTarget)selector4$temp;
                    {
                        ChunkPos patt7$temp;
                        pos = patt7$temp = $b$1.pos();
                    }
                    buf.writeByte(1);
                    buf.writeChunkPos(pos);
                    return;
                }
                case 2: {
                    int patt8$temp;
                    EntityTarget $b$2 = (EntityTarget)selector4$temp;
                    {
                        int tmp0$ = patt8$temp = $b$2.entity();
                    }
                    int entityId = patt8$temp;
                    buf.writeByte(2);
                    buf.writeVarInt(entityId);
                    return;
                }
                case 3: 
            }
            LevelTarget $b$3 = (LevelTarget)selector4$temp;
            buf.writeByte(3);
        }, buf -> {
            byte type = buf.readByte();
            switch (type) {
                case 0: {
                    return new BlockEntityTarget(buf.readBlockPos());
                }
                case 1: {
                    return new ChunkTarget(buf.readChunkPos());
                }
                case 2: {
                    return new EntityTarget(buf.readVarInt());
                }
                case 3: {
                    return new LevelTarget();
                }
            }
            throw new IllegalArgumentException("Unknown target type: " + type);
        });
    }

    public record LevelTarget() implements Target
    {
    }

    public record EntityTarget(int entity) implements Target
    {
    }

    public record ChunkTarget(ChunkPos pos) implements Target
    {
    }

    public record BlockEntityTarget(BlockPos pos) implements Target
    {
    }
}

