/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.world.poi;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.world.poi.ExtendPoiTypesEvent;
import net.neoforged.neoforge.common.world.poi.PoiStateSet;
import net.neoforged.neoforge.registries.GameData;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

@ApiStatus.Internal
public final class PoiTypeExtender {
    public static void extendPoiTypes() {
        ModLoader.postEvent((Event)new ExtendPoiTypesEvent(PoiTypeExtender::register));
    }

    private static void register(ResourceKey<PoiType> typeKey, Set<BlockState> states) {
        Object state2;
        Map<BlockState, Holder<PoiType>> statePoiMap = GameData.getBlockStatePointOfInterestTypeMap();
        Holder.Reference type = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getOrThrow(typeKey);
        for (Object state2 : states) {
            Holder<PoiType> prevType = statePoiMap.putIfAbsent((BlockState)state2, (Holder<PoiType>)type);
            if (prevType == null) continue;
            throw new IllegalStateException(String.format(Locale.ROOT, "%s is defined in more than one PoI type (old: %s, new: %s)", state2, prevType.value(), type.value()));
        }
        state2 = ((PoiType)type.value()).matchingStates();
        if (!(state2 instanceof PoiStateSet)) {
            String message;
            List<String> accessors = Arrays.stream(PoiType.class.getDeclaredMethods()).filter(method -> method.isSynthetic() && method.isAnnotationPresent(Accessor.class) && method.getReturnType() == Void.TYPE && method.getParameterCount() == 1 && method.getParameterTypes()[0] == Set.class).map(mth -> mth.getAnnotation(MixinMerged.class)).filter(Objects::nonNull).map(MixinMerged::mixin).toList();
            if (accessors.isEmpty()) {
                message = String.format(Locale.ROOT, "The matchingStates set of PoiType %s was replaced after construction", Objects.requireNonNull(type.getKey()).identifier());
            } else {
                StringBuilder accessorList = new StringBuilder();
                for (String accessor : accessors) {
                    accessorList.append("\n").append(accessor);
                }
                message = String.format(Locale.ROOT, "The matchingStates set of PoiType %s was replaced after construction. Accessor mixins for mutating the set were found:%s", Objects.requireNonNull(type.getKey()).identifier(), accessorList);
            }
            throw new IllegalStateException(message);
        }
        PoiStateSet poiStateSet = (PoiStateSet)state2;
        poiStateSet.addCustomStates(states);
    }

    private PoiTypeExtender() {
    }
}

