/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer;

import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.resource.ResourceStack;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public final class ResourceHandlerUtil {
    private ResourceHandlerUtil() {
    }

    public static boolean isEmpty(Resource resource, int amount) {
        return amount <= 0 || resource.isEmpty();
    }

    public static boolean isEmpty(ResourceHandler<? extends Resource> handler) {
        int size = handler.size();
        for (int i = 0; i < size; ++i) {
            if (handler.getAmountAsLong(i) <= 0L) continue;
            return false;
        }
        return true;
    }

    public static <T extends Resource> boolean isFull(ResourceHandler<T> handler) {
        int size = handler.size();
        for (int i = 0; i < size; ++i) {
            if (handler.getAmountAsLong(i) >= handler.getCapacityAsLong(i, handler.getResource(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Resource> boolean isValid(ResourceHandler<T> handler, T resource) {
        TransferPreconditions.checkNonEmpty(resource);
        int size = handler.size();
        for (int i = 0; i < size; ++i) {
            if (!handler.isValid(i, resource)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Resource> int getRedstoneSignalFromResourceHandler(ResourceHandler<T> handler) {
        float proportion = 0.0f;
        int sampleCount = 0;
        int size = handler.size();
        for (int index = 0; index < size; ++index) {
            long capacity;
            long indexFill = handler.getAmountAsLong(index);
            if (indexFill <= 0L || (capacity = handler.getCapacityAsLong(index, handler.getResource(index))) <= 0L) continue;
            proportion += Math.min(1.0f, (float)indexFill / (float)capacity);
            ++sampleCount;
        }
        if (sampleCount == 0) {
            return 0;
        }
        return Mth.lerpDiscrete((float)(proportion /= (float)sampleCount), (int)0, (int)15);
    }

    public static <T extends Resource> int insertStacking(@Nullable ResourceHandler<T> handler, T resource, int amount, @Nullable TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        if (handler == null || amount == 0) {
            return 0;
        }
        try (Transaction tx = Transaction.open(transaction);){
            int index;
            int inserted = 0;
            int size = handler.size();
            for (index = 0; index < size && (handler.getResource(index).isEmpty() || (inserted += handler.insert(index, resource, amount - inserted, tx)) != amount); ++index) {
            }
            if (inserted < amount) {
                for (index = 0; !(index >= size || handler.getResource(index).isEmpty() && (inserted += handler.insert(index, resource, amount - inserted, tx)) == amount); ++index) {
                }
            }
            tx.commit();
            int n = inserted;
            return n;
        }
    }

    @Nullable
    public static <T extends Resource> ResourceStack<T> extractFirst(@Nullable ResourceHandler<T> handler, Predicate<T> filter, int amount, @Nullable TransactionContext transaction) {
        TransferPreconditions.checkNonNegative(amount);
        if (handler == null || amount == 0) {
            return null;
        }
        T resource = ResourceHandlerUtil.findExtractableResource(handler, filter, transaction);
        if (resource == null) {
            return null;
        }
        try (Transaction tx = Transaction.open(transaction);){
            int extracted = handler.extract(resource, amount, tx);
            if (extracted > 0) {
                tx.commit();
                ResourceStack<T> resourceStack = new ResourceStack<T>(resource, extracted);
                return resourceStack;
            }
            ResourceStack<T> resourceStack = null;
            return resourceStack;
        }
    }

    public static <T extends Resource> int move(@Nullable ResourceHandler<T> from, @Nullable ResourceHandler<T> to, Predicate<T> filter, int amount, @Nullable TransactionContext transaction) {
        Objects.requireNonNull(filter, "Filter may not be null");
        TransferPreconditions.checkNonNegative(amount);
        if (from == null || to == null || amount == 0) {
            return 0;
        }
        Transaction subTransaction = Transaction.open(transaction);
        try {
            int totalMoved = 0;
            int size = from.size();
            for (int index = 0; index < size; ++index) {
                int maxExtracted;
                T fromResource = from.getResource(index);
                if (fromResource.isEmpty() || !filter.test(fromResource)) continue;
                try (Transaction simulatedExtract = Transaction.open(subTransaction);){
                    maxExtracted = from.extract(index, fromResource, amount - totalMoved, simulatedExtract);
                }
                if (maxExtracted == 0) continue;
                try (Transaction transferTransaction = Transaction.open(subTransaction);){
                    int inserted = to.insert(fromResource, maxExtracted, transferTransaction);
                    if (inserted != from.extract(index, fromResource, inserted, transferTransaction)) continue;
                    transferTransaction.commit();
                    if ((totalMoved += inserted) < amount) continue;
                    break;
                }
            }
            subTransaction.commit();
            int n = totalMoved;
            if (subTransaction != null) {
                subTransaction.close();
            }
            return n;
        }
        catch (Throwable totalMoved) {
            try {
                if (subTransaction != null) {
                    try {
                        subTransaction.close();
                    }
                    catch (Throwable throwable) {
                        totalMoved.addSuppressed(throwable);
                    }
                }
                throw totalMoved;
            }
            catch (Exception e) {
                CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Moving resources between resource handlers");
                report.addCategory("Move details").setDetail("Input", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(from)).setDetail("Output", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(to)).setDetail("Filter", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(filter)).setDetail("Amount", (Object)amount).setDetail("Transaction", (Object)transaction);
                throw new ReportedException(report);
            }
        }
    }

    @Nullable
    public static <T extends Resource> ResourceStack<T> moveFirst(@Nullable ResourceHandler<T> from, @Nullable ResourceHandler<T> to, Predicate<T> filter, int amount, @Nullable TransactionContext transaction) {
        Objects.requireNonNull(filter, "Filter may not be null");
        TransferPreconditions.checkNonNegative(amount);
        if (from == null || to == null || amount == 0) {
            return null;
        }
        try {
            int totalMoved = 0;
            Object selectedResource = null;
            int size = from.size();
            for (int index = 0; index < size; ++index) {
                int extracted;
                T fromResource = from.getResource(index);
                if (selectedResource == null && (fromResource.isEmpty() || !filter.test(fromResource)) || selectedResource != null && !selectedResource.equals(fromResource)) continue;
                try (Transaction simulatedExtractTransaction = Transaction.open(transaction);){
                    extracted = from.extract(index, fromResource, amount - totalMoved, simulatedExtractTransaction);
                }
                if (extracted == 0) continue;
                try (Transaction transferTransaction = Transaction.open(transaction);){
                    int inserted = to.insert(fromResource, extracted, transferTransaction);
                    if (inserted == 0 || inserted != from.extract(index, fromResource, inserted, transferTransaction)) continue;
                    transferTransaction.commit();
                    selectedResource = fromResource;
                    if ((totalMoved += inserted) < amount) continue;
                    break;
                }
            }
            return totalMoved > 0 ? new ResourceStack<Object>(selectedResource, totalMoved) : null;
        }
        catch (Exception e) {
            CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Moving resources between storages");
            report.addCategory("Move details").setDetail("Input", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(from)).setDetail("Output", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(to)).setDetail("Filter", (CrashReportDetail)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(filter)).setDetail("Amount", (Object)amount).setDetail("Transaction", (Object)transaction);
            throw new ReportedException(report);
        }
    }

    public static <T extends Resource> boolean contains(ResourceHandler<T> handler, T resource) {
        return ResourceHandlerUtil.indexOf(handler, resource) != -1;
    }

    public static <T extends Resource> int indexOf(ResourceHandler<T> handler, T resource) {
        TransferPreconditions.checkNonEmpty(resource);
        int size = handler.size();
        for (int index = 0; index < size; ++index) {
            if (!resource.equals(handler.getResource(index))) continue;
            return index;
        }
        return -1;
    }

    @Nullable
    public static <T extends Resource> T findExtractableResource(ResourceHandler<T> handler, Predicate<T> filter, @Nullable TransactionContext transaction) {
        try (Transaction temp = Transaction.open(transaction);){
            int size = handler.size();
            for (int index = 0; index < size; ++index) {
                T resource = handler.getResource(index);
                if (resource.isEmpty() || !filter.test(resource) || handler.extract(index, resource, handler.getAmountAsInt(index), temp) <= 0) continue;
                T t = resource;
                return t;
            }
            T t = null;
            return t;
        }
    }
}

