/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.standalone;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.util.thread.ParallelMapTransform;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class StandaloneModelLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    private StandaloneModelLoader() {
    }

    public static CompletableFuture<LoadedModels> load(Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            IdentityHashMap models = new IdentityHashMap();
            ModLoader.postEvent((Event)new ModelEvent.RegisterStandalone(models));
            return new LoadedModels(models);
        }, executor);
    }

    public static CompletableFuture<BakedModels> bake(LoadedModels standaloneModels, ModelBaker baker, Executor executor) {
        return ParallelMapTransform.schedule(standaloneModels.models, (key, model) -> {
            try {
                return model.bake(baker);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to bake standalone model: '{}': {}", (Object)key.getName(), (Object)e);
                return null;
            }
        }, (Executor)executor).thenApply(BakedModels::new);
    }

    public record LoadedModels(Map<StandaloneModelKey<?>, UnbakedStandaloneModel<?>> models) {
        public static final LoadedModels EMPTY = new LoadedModels(Map.of());
    }

    public record BakedModels(Map<StandaloneModelKey<?>, ?> models) {
        public static final BakedModels EMPTY = new BakedModels(Map.of());

        @Nullable
        public <T> T get(StandaloneModelKey<T> key) {
            return (T)this.models.get(key);
        }

        public BakedModels unmodifiable() {
            return new BakedModels(Collections.unmodifiableMap(this.models));
        }
    }
}

