/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.world.inventory.StackCopySlot;

public class ResourceHandlerSlot
extends StackCopySlot {
    private final ResourceHandler<ItemResource> handler;
    private final IndexModifier<ItemResource> slotModifier;
    private final int index;

    public ResourceHandlerSlot(ResourceHandler<ItemResource> handler, IndexModifier<ItemResource> slotModifier, int index, int xPosition, int yPosition) {
        super(xPosition, yPosition);
        this.handler = handler;
        this.slotModifier = slotModifier;
        this.index = index;
    }

    public boolean mayPlace(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.handler.isValid(this.index, ItemResource.of(stack));
    }

    @Override
    protected ItemStack getStackCopy() {
        return this.handler.getResource(this.index).toStack(this.handler.getAmountAsInt(this.index));
    }

    @Override
    protected void setStackCopy(ItemStack stack) {
        this.slotModifier.set(this.index, ItemResource.of(stack), stack.getCount());
    }

    public void onQuickCraft(ItemStack oldStackIn, ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return this.handler.getCapacityAsInt(this.index, ItemResource.EMPTY);
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.handler.getCapacityAsInt(this.index, ItemResource.of(stack));
    }

    public boolean mayPickup(Player player) {
        try (Transaction tx = Transaction.open(null);){
            boolean bl = this.handler.extract(this.index, this.handler.getResource(this.index), 1, tx) == 1;
            return bl;
        }
    }

    public ResourceHandler<ItemResource> getResourceHandler() {
        return this.handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameInventory(Slot other) {
        if (!(other instanceof ResourceHandlerSlot)) return false;
        ResourceHandlerSlot rhs = (ResourceHandlerSlot)other;
        if (rhs.handler != this.handler) return false;
        return true;
    }
}

