/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ContainerOrHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VanillaInventoryCodeHooks {
    public static boolean extractHook(Hopper dest, ResourceHandler<ItemResource> handler) {
        int size = handler.size();
        for (int index = 0; index < size; ++index) {
            ItemResource itemResource = handler.getResource(index);
            if (itemResource.isEmpty()) continue;
            try (Transaction tx = Transaction.open(null);){
                int extracted = handler.extract(index, itemResource, 1, tx);
                if (extracted == 0) continue;
                ItemStack extractedStack = itemResource.toStack();
                int destSize = dest.getContainerSize();
                for (int j = 0; j < destSize; ++j) {
                    ItemStack destStack = dest.getItem(j);
                    if (!dest.canPlaceItem(j, extractedStack) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= dest.getMaxStackSize() || !itemResource.matches(destStack))) continue;
                    if (destStack.isEmpty()) {
                        dest.setItem(j, extractedStack);
                    } else {
                        destStack.grow(1);
                        dest.setItem(j, destStack);
                    }
                    dest.setChanged();
                    tx.commit();
                    boolean bl = true;
                    return bl;
                }
                continue;
            }
        }
        return false;
    }

    public static boolean insertHook(HopperBlockEntity hopper, ResourceHandler<ItemResource> itemHandler) {
        if (ResourceHandlerUtil.isFull(itemHandler)) {
            return false;
        }
        try (Transaction tx = Transaction.open(null);){
            int size = hopper.getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack hopperItem = hopper.getItem(i);
                if (hopperItem.isEmpty()) continue;
                ItemStack originalSlotContents = hopperItem.copy();
                ItemStack insertStack = hopper.removeItem(i, 1);
                if (itemHandler.insert(ItemResource.of(insertStack), 1, tx) == 1) {
                    tx.commit();
                    boolean bl = true;
                    return bl;
                }
                hopper.setItem(i, originalSlotContents);
            }
        }
        return false;
    }

    public static ContainerOrHandler getEntityContainerOrHandler(Level level, double x, double y, double z, @Nullable Direction side) {
        List list = level.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), entity -> {
            if (!entity.isAlive()) {
                return false;
            }
            return entity instanceof Container || entity.getCapability(Capabilities.Item.ENTITY_AUTOMATION, (Object)side) != null;
        });
        if (!list.isEmpty()) {
            Entity entity2 = (Entity)list.get(level.random.nextInt(list.size()));
            if (entity2 instanceof Container) {
                Container container = (Container)entity2;
                return new ContainerOrHandler(container, null);
            }
            ResourceHandler entityCap = (ResourceHandler)entity2.getCapability(Capabilities.Item.ENTITY_AUTOMATION, (Object)side);
            if (entityCap != null) {
                return new ContainerOrHandler(null, entityCap);
            }
        }
        return ContainerOrHandler.EMPTY;
    }
}

